'use client';

import React from 'react';
import { IRole } from '@/shared/types/role';
import TableManager from '@/shared/components/table/table-manager';
import { TableColumn } from '@/shared/types/common';
import RoleTableRow from '../view/role-table-row';
import { RoleStatus } from '@/shared/api/stores/roleStore';

interface RoleTableProps {
  filteredData: IRole[];
  table: any;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (role: IRole) => void;
  handleView: (role: IRole) => void;
  handleArchive: (role: IRole) => void;
  onStatusChange: (row: IRole, newStatus: RoleStatus) => void;
}

export default function RoleTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  handleArchive,
  onStatusChange,
  
}: RoleTableProps) {
  const renderRow = (row: IRole) => (
    <RoleTableRow
      key={row.id}
      row={row}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      handleEditRole={handleEdit}
      handleDetailsRole={handleView}
      handleArchiveRole={handleArchive}
      columns={tableHead}
      onStatusChange={onStatusChange}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
  );
}