import * as Yup from 'yup';
import { ROLE_STATUS } from '@/shared/_mock/_roles';
import { RoleStatus } from '@/shared/api/stores/roleStore';

export const roleSchema = Yup.object().shape({
  name: Yup.string()
      .required('Le nom du rôle est requis')
      .min(2, 'Le nom doit contenir au moins 2 caractères')
      .max(100, 'Le nom ne peut pas dépasser 100 caractères'),
  description: Yup.string()
      .required('La description est requise')
      .min(10, 'La description doit contenir au moins 10 caractères')
      .max(500, 'La description ne peut pas dépasser 500 caractères'),
  status: Yup.mixed<RoleStatus>()
      .required('Le statut est requis')
      .oneOf(Object.values(RoleStatus), 'Statut invalide'),
  modules: Yup.array()
      .of(
          Yup.object().shape({
              module: Yup.string().required('Le module est requis'),
              permissions: Yup.array()
                  .of(Yup.string())
                  .min(1, 'Au moins une permission est requise pour chaque module'),
          })
      ),
  createdAt: Yup.date()
      .required('La date de création est requise')
      .nullable()
      .typeError('La date de création doit être une date valide'),
});