import { FormFieldType } from '@/shared/types/common';
import { ISector, SectorList, SectorRequest } from '@/shared/types/infrastructure';
import { faBriefcase, faFile, faMapLocation } from '@fortawesome/free-solid-svg-icons';

export const mainSectorFormFields: FormFieldType<SectorList>[] = [
  {
    name: 'name',
    label: 'Nom du secteur',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faBriefcase
  },
  {
    name: 'address',
    label: 'Adresse',
    placeholder: 'Entrez un texte',
    type: 'address',
    icon: faMapLocation,
  },
  {
    name: 'createdAt',
    label: 'Date de création',
    placeholder: 'Date de création',
    type: 'date',
    icon: faFile,
  },
];

export const mainSectorConsultFormFields: FormFieldType<SectorRequest>[] = [
  {
    name: 'name',
    label: 'Nom du secteur',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faBriefcase
  },
  {
    name: 'mapAddresse',
    label: 'Adresse',
    placeholder: 'Entrez un texte',
    type: 'address',
    required: true,
    icon: faMapLocation,
  },
  {
    name: 'description',
    label: 'Description',
    placeholder: 'Écrivez un texte ici',
    type: 'textarea',
    icon: faFile,
  },
];


export const detailsSectorFormFields: FormFieldType<SectorRequest>[] = [
  {
    name: 'name',
    label: 'Nom du secteur',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faBriefcase
  },
  {
    name: 'mapAddresse',
    label: 'Adresse',
    placeholder: 'Entrez un texte',
    type: 'address',
    icon: faMapLocation,
  },
  {
    name: 'description',
    label: 'Description',
    placeholder: 'Écrivez un texte ici',
    type: 'textarea',
    icon: faFile,
  },
];