import type React from 'react';
import { Grid } from '@mui/material';
import type { ModeType } from '@/shared/types/common';
import ActionButtons from '@/shared/components/form/buttons-action';

import HorairesSpecifiqueTabs from '@/shared/sections/usager/components/usager-form/avenants-horaires/horaires-specifique-tabs';
import EditExportButtons from '@/shared/components/form/edit-export-buttons';
import { IAvenant } from '@/shared/types/circuit';
import { ScheduleDTO } from '@/shared/types/amendment';

interface EtablissementTabProps {
  mode: ModeType;
  onSave: () => void;
  onClose: (isSaved: boolean) => void;
  onEdit: () => void;
  avenant?: IAvenant;
  schedules?: ScheduleDTO[];
}

export default function AvenantHoraireForm({
  mode,
  onSave,
  onClose,
  onEdit,
  avenant,
  schedules
}: EtablissementTabProps) {
  const isReadOnly = mode === 'view';
  return (
    <>
      {isReadOnly ? (
        <EditExportButtons onEdit={onEdit} tooltipTitle="les horaires" />
      ) : (
        <></>
      )}
      <form>
        <Grid container spacing={3}>
          <Grid item xs={12}>
          <HorairesSpecifiqueTabs
            isReadOnly={isReadOnly}
            title=''
            withData={mode !== "add"}
            schedules={schedules}
          />
          </Grid>
          {!isReadOnly ? (
            <Grid item xs={12}>
              <ActionButtons onSave={onSave} onCancel={() => onClose(false)} mode={mode} />
            </Grid>
          ) : <></>}
        </Grid>
      </form>
    </>
  );
}
