import { TabConfig, useTabsManager } from '../../../../hooks/use-tabs-manager';
import { IAvenant } from '@/shared/types/circuit';

const EMPTY_AVENANT_DATA: IAvenant = {
  id: '',
  dateApplication: '',
  etat: 'non_controle',
  codeCircuit: '',
  codeAvenant: '',
  intitule: '',
  objetAvenant: '',
  type: '',
  dateFin: '',
  etablissement: '',
  chauffeur: '',
  societe: '',
  clientDO: '',
  isActive: true,
  objet: '',
};

const avenantConfig: TabConfig<IAvenant> = {
  type: 'avenant',
  listTitle: 'Liste des avenants',
  newItemTitle: 'Nouveau avenant',
  initialData: EMPTY_AVENANT_DATA,
  getItemCode: (avenant) => avenant.intitule,
};

export function useAvenantTabs() {
  return useTabsManager<IAvenant>(avenantConfig);
}

