import { Civility } from '@/shared/types/client';
import type { FormFieldType } from '@/shared/types/common';
import type { IDriverType } from '@/shared/types/driver';
import {
  faCalendarDays,
  faMobileScreenButton,
  faEnvelope,
  faHashtag,
  faUserTie,
  faTag,
  faAddressCard,
  faMagnifyingGlassLocation,
} from '@fortawesome/free-solid-svg-icons';
import { DriverStatus } from '@/shared/types/driver';

export const driverFormFields = (
  departmentOptions?: { label: string; value: string }[]
): FormFieldType<IDriverType>[] => [
{
    name: "civility",
    label: "Civilité",
    type: "checkbox",
    options: Object.keys(Civility).map(key => ({
      value: Civility[key as keyof typeof Civility],
      label: Civility[key as keyof typeof Civility],
    })),
  },
  {
    name: 'lastName',
    label: 'Nom',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'firstName',
    label: 'Prénom',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'birthDate',
    label: 'Date de naissance',
    type: 'date',
    placeholder: 'JJ/MM/AAAA',
  },
  {
    name: 'phoneNumber',
    label: 'Téléphone',
    type: 'text',
    placeholder: '0000 000 000 000',
    icon: faMobileScreenButton,
  },
  {
     name: "mapAdresse", 
     label: "Adresse complète",
     type: "address",
     placeholder: "Saisissez une adresse",
     icon: faMagnifyingGlassLocation,
     
     
   },
  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    icon: faEnvelope,
  },

  {
    name: 'entryDate',
    label: "Date d'entrée",
    type: 'date',
    placeholder: 'JJ/MM/AAAA',
    icon: faCalendarDays,
  },
  {
    name: 'vehicleName',
    label: 'Véhicule attribué',
    type: 'combobox',
    placeholder: 'Choisissez un véhicule',
  },
  {
    name: 'departmentId',
    label: 'Département',
    type: 'combobox',
    placeholder: 'Choisissez un département',
    options: departmentOptions || [],
  },
  {
    name: 'circuitNames',
    label: 'Circuit',
    type: 'select',
    placeholder: 'Choisissez un circuit',
  },
  {
    name: 'imatriculation',
    label: 'Immatriculation',
    type: 'text',
    placeholder: 'AAAA 0000 0000 0000',
    icon: faTag,
  },
  {
    name: "fuelCardNames",
    label: 'Numéro carte carburant',
    type: 'multiple',
   
  },
  {
    name: 'socialSecurityNumber',
    label: 'Numéro de securite social',
    type: 'text',
    placeholder: 'AAAA 0000 0000 0000',
    icon: faHashtag,
  },
  {
    name: 'driverStatus',
    label: 'Status',
    type: 'select',
    options: [
      { value: DriverStatus.AVAILABLE, label: 'Disponible' },
      { value: DriverStatus.ABSENT, label: 'Absent' }
    ]
  },
  {
    name: 'fuelVolume',
    label: 'Type de carburant',
    type: 'multiple',
    placeholder: 'Choisissez un ou plusieurs types',
  },
  {
    name: "drivingLicenseName",
    label: "Permis",
    type: "select",
    placeholder: "Choisissez un type",
  },
  {
    name: "drivingLicenseExpirationDate",
    label: "Date d'expiration permis",
    type: "date",
  },
  {
    name: "residenceCardTitle",
    label: "Titre de carte de séjour",
    type: "text",
    placeholder: "Entrez un texte",
    icon: faAddressCard,
  },
  {
    name: "residencePermitOrIDCard",
    label: "CNI",
    type: "text",
    placeholder: "AAAA 0000 000 0000",
    icon: faHashtag,
  },
];
