import { useState } from 'react';
import { Box, Typography, Button, Stack, Grid, ClickAwayListener } from '@mui/material';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { faCar, faUser, faIdBadge, faBuilding, faGasPump } from '@fortawesome/free-solid-svg-icons';
import { pxToRem } from '@/shared/theme/typography';
import FontAwesome from '@/shared/components/fontawesome';

import dayjs, { Dayjs } from 'dayjs';
import { StaticDatePicker } from '@mui/x-date-pickers';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import 'dayjs/locale/fr';
type Props = {
  handleOnClick: () => void;
};

export default function UserInformationCard({ handleOnClick }: Props) {
  const today = dayjs();
  const startOfMonth = today.startOf('month');
  const endOfMonth = today.endOf('month');
  const [selectedDate, setSelectedDate] = useState<Dayjs | null>(today);

  const mockData = {
    departement: 'Département Soleil',
    adresse: '75. Agence Soleil Avenue de la somme',
    prenom: 'Anna',
    nom: 'Leblanc',
    carteCarburant: 'XX07905968',
    immatriculation: 'GA 689479',
    licence: '689479',
  };

  return (
    <LocalizationProvider dateAdapter={AdapterDayjs} adapterLocale="fr">
      <Box
        sx={{
          borderRadius: 5,
          display: 'flex',
          flexDirection: 'row',
        }}
      >
        <Box
          sx={{
            p: 1,
            borderRadius: 5,
            display: 'flex',
            flexDirection: 'column',
            gap: 4,
            flex: 2,
          }}
        >
          <Box sx={{ bgcolor: 'white', p: 3, borderRadius: 2, boxShadow: 1 , height: '100%'}}>
            <Typography
              sx={{
                textAlign: 'center',
                fontSize: pxToRem(30),
                color: 'primary.main',
                fontWeight: (theme) => theme.typography.fontWeightBold,
                mb: 2,
              }}
            >
              {mockData.departement}
            </Typography>

            <Grid container spacing={3}>
              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faUser} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>Prénom :&nbsp;{mockData.prenom}</Typography>
                  </Grid>
                </Grid>
              </Grid>

              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faCar} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>Immatriculation : {mockData.immatriculation}</Typography>
                  </Grid>
                </Grid>
              </Grid>

              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faUser} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>Nom :&nbsp;{mockData.nom}</Typography>
                  </Grid>
                </Grid>
              </Grid>

              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faGasPump} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>Carte carburant :&nbsp;{mockData.carteCarburant}</Typography>
                  </Grid>
                </Grid>
              </Grid>

              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faIdBadge} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>
                      Num copie de conforme de la licence : {mockData.licence}
                    </Typography>
                  </Grid>
                </Grid>
              </Grid>
              <Grid item xs={12}>
                <Grid container direction="row" alignItems="center" spacing={1}>
                  <Grid item>
                    <FontAwesome icon={faBuilding} color="primary.main" width={16} />
                  </Grid>
                  <Grid item>
                    <Typography>Adresse :&nbsp;{mockData.adresse}</Typography>
                  </Grid>
                </Grid>
              </Grid>
            </Grid>
          </Box>
        </Box>

        <Box
          sx={{
            flex: 1,
            bgcolor: 'white',
            pt: 3,
            pb: 3,
            m: 1,
            borderRadius: 2,
            boxShadow: 1,
            width: '100%',
            display: 'flex',
            flexDirection: 'column',
            gap: 0,
            position: 'relative',
          }}
        >
          <Grid container gap={0} spacing={0}>
            <Grid item xs={12} sm={12} md={6}>
              <Box sx={{ position: 'relative' }}>
                <Typography variant="body1" color="primary.main" sx={{ mb: 1, pl: 2, pt: 1 }}>
                  Choisir une date
                </Typography>
              </Box>
            </Grid>
            <Grid item xs={12} sm={12} md={6}>
              <Box
                sx={{
                  display: 'flex',
                  alignItems: 'end',
                  justifyContent: 'space-around',
                  cursor: 'pointer',
                  ml: 2,
                }}
                onClick={() => handleOnClick()}
              >
                <Button variant="contained" color="primary">
                  Liste des trajets
                </Button>
              </Box>
            </Grid>
          </Grid>
          <StaticDatePicker
            value={selectedDate}
            onChange={(newValue) => setSelectedDate(newValue)}
            minDate={startOfMonth}
            maxDate={endOfMonth}
            displayStaticWrapperAs="desktop"
            showDaysOutsideCurrentMonth={false}
            views={['day']}
            openTo="day"
            shouldDisableDate={(date) =>
              date.isBefore(startOfMonth, 'day') || date.isAfter(endOfMonth, 'day')
            }
            sx={{
              '& .MuiPickersArrowSwitcher-root': {
                display: 'none',
              },
              '& .MuiDateCalendar-root': {
                maxHeight: '280px',
              },
              '& .MuiPickersCalendarHeader-root ': {
                marginTop: '-10px',
              },
            }}
          />
          <Box display="flex" justifyContent="space-between" alignItems="center">
            <ConditionalComponent isValid={!!selectedDate}>
              <Typography
                variant="h6"
                sx={{
                  color: 'primary.main',
                  fontWeight: (theme) => theme.typography.fontWeightBold,
                  textTransform: 'capitalize',
                  pl: 2,
                  mb: 2,
                }}
                gutterBottom
              >
                {selectedDate?.locale('fr').format('dddd D MMMM YYYY')}
              </Typography>
            </ConditionalComponent>
          </Box>

          <Stack direction="row" spacing={2} justifyContent="flex-end" sx={{ pr: 2 }}>
            <Button variant="outlined" color="primary">
              Annuler
            </Button>
            <Button variant="contained" color="primary">
              Valider
            </Button>
          </Stack>
        </Box>
      </Box>
    </LocalizationProvider>
  );
}
