'use client';

import React from 'react';
import { Box, IconButton, Stack, Typography } from '@mui/material';
import { useRouter } from 'next/navigation';
import { HEADER } from '@/layouts/config-layout';
import { useOldRoadMapTabs } from '../components/hooks/use-old-roadmap-tabs';
import { useOldRoadMapTable } from '../components/hooks/use-old-roadmap-table';
import TableControlBar from '@/shared/components/table/table-control-bar';
import CustomTabs from '@/shared/components/tabs/tabs-custom';
import { TableType } from '@/shared/types/common';
import FontAwesome from '@/shared/components/fontawesome';
import { faArrowLeft } from '@fortawesome/free-solid-svg-icons';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import OldSubmittedRoadMapsTable from '../components/roadmap-list/old-submitted-roadmap/old-roadmaps-table';
import TabsCustom from '@/shared/components/tabs/tabs-custom';

export default function OldSubmittedRoadMapsView() {
  const router = useRouter();

  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleCopy,
  } = useOldRoadMapTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    dataToExport,
  } = useOldRoadMapTable();

  const isList = activeTab === 'list';

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Box sx={{ px: 2, py: 1 }}>
        <CustomTooltip title="Retour à la page précédente" arrow>
          <IconButton sx={WhiteIconButtonStyle} onClick={() => router.back()}>
            <FontAwesome icon={faArrowLeft} width={18} />
          </IconButton>
        </CustomTooltip>
      </Box>

      <Typography
          variant="h5"
          sx={{
            color: 'primary.main',
            fontWeight: (theme) => theme.typography.fontWeightBold,
          }}
        >
          Anciennes feuilles de route soumises
        </Typography>

        <Stack flexGrow={0} direction="row" alignItems="center" justifyContent="flex-end" spacing={{ xs: 0.5, sm: 1 }}>
        <TableControlBar
            type={TableType.DriverRoadmap}
            activeTab={activeTab}
            onResetFilters={handleResetFilters}
            onResetColumns={handleResetColumns}
            onColumnsChange={handleColumnsChange}
            initialColumns={tableHead.slice(0, -1)}
            onFilters={handleFilterChange}
            filteredData={dataToExport}
          />
                  </Stack>

         <TabsCustom
          type={TableType.Driver}
          tabs={tabs}
          activeTab={activeTab}
          handleTabChange={handleTabChange}
          handleTabClose={handleTabClose}
        />
        

      <OldSubmittedRoadMapsTable
        table={table}
        filteredData={filteredData}
        filters={filters}
        tableHead={tableHead}
        notFound={notFound}
        dataToExport={dataToExport}
        activeTab={activeTab}
        onFilterChange={handleFilterChange}
        onResetFilters={handleResetFilters}
        onResetColumns={handleResetColumns}
        onColumnsChange={handleColumnsChange}
        handleEdit={handleEdit}
        handleCopy={handleCopy}
        handleView={handleView}
      />
    </Box>
  );
}
