import { Chip, TableRow } from '@mui/material';
import { alpha, styled } from '@mui/system';
import { PrioriteDemande } from '@/shared/types/demande';
import { DemandeStatus } from '@/shared/types/demande';
import { InterventionTab } from '@/shared/types/flottes/intervention';
import { EmailStatus } from '@/shared/types/email';
import { NotificationStatus } from '@/shared/types/notification';
import { ContractStatus } from '@/shared/types/contract';
import { DriverRoadMapStatus } from '@/shared/types/driver';
import { baseChipStyles } from '@/shared/theme/css';


export const StatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    ...baseChipStyles,
    ...((status === 'nouveau' || status === 'personnalise' || status === 'averti' || status === 'aller' || status === ContractStatus.IN_PROGRESS) && {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
      color: theme.palette.primary.main,
    }),
    ...((status === 'resilie' || status === 'non_controle' || status === 'non' || status === 'non_traite' || status === 'annule' || status === 'absent' || status === 'non_affecte' || status === 'non_valide' || status === InterventionTab.EnAttente || status === ContractStatus.IN_PROGRESS) && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...((status === 'en_cours' || status === 'controle' || status === 'oui' || status === 'traite' || status === 'disponible' || status === 'affecte' || status === 'valide' || status === ContractStatus.CANCELLED) && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...((status === 'termine' || status === ContractStatus.COMPLETED) && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...((status === 'archive' || status === ContractStatus.ARCHIVED) && {
      backgroundColor: alpha('#81919A', 0.1),
      color: '#81919A',
    }),
    ...(status === 'normal' && {
      backgroundColor: '#EEF1FF',
      color: '#5176FE',
    }),
    ...((status === 'modifie' || status === 'retour') && {
      color: '#81919A',
    }),
    // Demande mapping on status
    ...(status === DemandeStatus.EN_ATTENTE && {
      backgroundColor: alpha(theme.palette.warning.main, 0.1),
      color: theme.palette.warning.main,
    }),
    ...(status === DemandeStatus.EN_TRAITEMENT && {
      backgroundColor: alpha(theme.palette.info.main, 0.1),
      color: theme.palette.info.main,
    }),
    ...(status === DemandeStatus.VALIDEE && {
      backgroundColor: alpha(theme.palette.success.main, 0.1),
      color: theme.palette.success.main,
    }),
    ...(status === DemandeStatus.REFUSEE && {
      backgroundColor: alpha(theme.palette.error.main, 0.1),
      color: theme.palette.error.main,
    }),
    //priooritty demaannde
    // Style for 'Basse' (Low Priority)
    ...((status === PrioriteDemande.BASSE) && {
      backgroundColor: '#E5E5E5',
      color: '#A1A1A1',
    }),
    // Style for 'Normale' (Normal Priority)
    ...((status === PrioriteDemande.NORMALE) && {
      backgroundColor: '#B1E0FF',
      color: '#1D72B8',
    }),
    // Style for 'Haute' (High Priority)
    ...((status === PrioriteDemande.HAUTE) && {
      backgroundColor: alpha(theme.palette.error.main, 0.1),
      color: theme.palette.error.main,
    }),
    // Style for 'Urgente' (Urgent Priority)
    ...((status === PrioriteDemande.URGENTE) && {
      backgroundColor: '#FF4C4C',
      color: '#B72A2A',
    }),
    ...(status === DemandeStatus.EMPTY && {
      backgroundColor: alpha(theme.palette.grey[300], 0.1),
      color: theme.palette.grey[600],
    }),
    ...(status === EmailStatus.ENVOYE && {
      backgroundColor: alpha(theme.palette.success.main, 0.1),
      color: theme.palette.success.main,
    }),
    ...(status === EmailStatus.ECHEC && {
      backgroundColor: alpha(theme.palette.error.main, 0.1),
      color: theme.palette.error.main,
    }),
    ...(status === NotificationStatus.ARCHIVED && {
      backgroundColor: alpha(theme.palette.grey[500], 0.1),
      color: theme.palette.grey[600],
    }),
    ...(status === NotificationStatus.DELETED && {
      backgroundColor: alpha(theme.palette.error.main, 0.1),
      color: theme.palette.error.main,
    }),
    ...(status === NotificationStatus.PENDING && {
      backgroundColor: alpha(theme.palette.warning.main, 0.1),
      color: theme.palette.warning.main,
    }),
    ...(status === NotificationStatus.READ && {
      backgroundColor: alpha(theme.palette.success.main, 0.1),
      color: theme.palette.success.main,
    }),
    ...(status === NotificationStatus.SENT && {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
      color: theme.palette.primary.main,
    }),
    ...(status === NotificationStatus.UNREAD && {
      backgroundColor: alpha(theme.palette.info.main, 0.1),
      color: theme.palette.info.main,
    }),
  },
}));

export const DriverStatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    ...baseChipStyles,
  ...(status === DriverRoadMapStatus.Disponible && {
    backgroundColor: theme.palette.success.lighter,
    color: theme.palette.success.main,
  }),
  ...(status === DriverRoadMapStatus.Affecte && {
    backgroundColor: theme.palette.info.lighter,
    color: theme.palette.info.main,
  }),
  ...(status === DriverRoadMapStatus.Absent && {
    backgroundColor: '#FFE1E1',
    color: '#FF3434',
  }),
  ...(status === DriverRoadMapStatus.Suspendu && {
    backgroundColor: '#81919A',
    color: 'white',
  }),
  ...(status === DriverRoadMapStatus.NonDisponible && {
    backgroundColor: theme.palette.warning.lighter,
      color: theme.palette.warning.main,
  }),
}
}));

export const getStatusColor = (status: string) => {
  switch (status) {
    case 'en_cours':
    case 'controle':
      return '#22c55e';
    case 'resilie':
      return '#ef4444';
    case 'actif':
        return '#eab308';
    case 'archive':
    case 'non_controle':
      return '#81919A';
    case 'disponible':
      return '#22c55e';
    case 'non_disponible':
      return '#81919A';
    case 'affecte':
      return '#eab308';
    case 'suspendu':
      return '#ef4444';
    default:
      return '#F9B90B ';
  }
};
// Styled Chip for priority representation
export const PriorityChip = styled(Chip)(({ priority, theme }: { priority: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    // Style for 'Basse' (Low Priority)
    ...((priority === PrioriteDemande.BASSE) && {
      backgroundColor: '#E5E5E5',
      color: '#A1A1A1',
    }),
    // Style for 'Normale' (Normal Priority)
    ...((priority === PrioriteDemande.NORMALE) && {
      backgroundColor: '#B1E0FF',
      color: '#1D72B8',
    }),
    // Style for 'Haute' (High Priority)
    ...((priority === PrioriteDemande.HAUTE) && {
      backgroundColor: alpha(theme.palette.error.main, 0.1),
      color: theme.palette.error.main,
    }),
    // Style for 'Urgente' (Urgent Priority)
    ...((priority === PrioriteDemande.URGENTE) && {
      backgroundColor: '#FF4C4C',
      color: '#B72A2A',
    }),
  },
}));

// Function to get priority colors
export const getPriorityColor = (priority: string) => {
  switch (priority) {
    case PrioriteDemande.BASSE:
      return '#A1A1A1'; // Grey for low priority
    case PrioriteDemande.NORMALE:
      return '#1D72B8'; // Blue for normal priority
    case PrioriteDemande.HAUTE:
      return '#F9A825'; // Yellow for high priority
    case PrioriteDemande.URGENTE:
      return '#B72A2A'; // Red for urgent priority
    default:
      return '#A1A1A1'; // Default to grey
  }
};

// Base styled row
export const BaseStyledRow = styled(TableRow)(({ theme }) => ({
  '& > *:first-of-type': {
    borderBottomLeftRadius: '10px',
    borderTopLeftRadius: '10px',
  },
  '& > *:last-child': {
    borderTopRightRadius: '10px',
    borderBottomRightRadius: '10px',
  },
}));

// Styled rows for different table sections
export const ContratStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
}));

export const WhiteStyledRow = styled(TableRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *': {
    borderBottom: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
}));

export const TrajetStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: alpha(theme.palette.primary.main, 0.1),
  '& > *': {
    borderTop: `3px solid white`,
  },
  '&:hover, &[data-selected="true"]': {
    outline: `1px solid ${theme.palette.primary.main}`,
    outlineOffset: '-3px',
    borderRadius: '8px',
  },
}));

export const PresenceStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: alpha(theme.palette.primary.main, 0.1),
  '& > *': {
    borderTop: `3px solid white`,
  },
}));

export const CircuitStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: 'white',
  '&:not(:last-child)': {
    borderBottom: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  },
  '&:hover': {
    transition: 'border 0.3s',
    backgroundColor: alpha(theme.palette.primary.main, 0.02),
  },
}));

export const DrawerStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: alpha(theme.palette.primary.main, 0.1),
  '& > *': {
    borderTop: `3px solid white`,
  },
  '&:hover': {
    backgroundColor: alpha(theme.palette.primary.main, 0.2),
  },
  '&.Mui-selected': {
    backgroundColor: alpha(theme.palette.primary.main, 0.23),
  },

}));
