"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import TableActionColumn from "@/shared/components/table/table-action-column"
import { useTheme } from "@mui/material/styles"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import { dateFormat, formatDate } from "@/utils/format-time"
import { ContratStyledRow, getStatusColor, StatusChip } from "@/shared/sections/contract/styles"
import StatusMenu from "@/shared/components/table/StatusMenu"
import { AFFECTATION_OPTION_STATUT, IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  handleEdit: (affectation: IVehicleAffectation) => void
  handleDetails: (affectation: IVehicleAffectation) => void
  handleCopy: (affectation: IVehicleAffectation) => void
  selected: boolean
  dense: boolean
  row: IVehicleAffectation
  onSelectRow: VoidFunction
  columns: TableColumn[]
  onStatusChange: (row: IVehicleAffectation, newStatus: string, field: keyof IVehicleAffectation) => void;
}

const TOOLTIP_TITLES = {
  edit: "Modifier affectation",
  active: "Affectation active",
  inactive: "Affectation inactive",
}

export default function AffectationTableRow({
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
  onStatusChange
}: Props) {
  const theme = useTheme()

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "dateAffectation":
      case "dateRetour":
        return formatDate(value, dateFormat.isoDate)
      case "statut":
        return (
          <StatusMenu
            value={value}
            options={AFFECTATION_OPTION_STATUT}
            onChange={(newStatus) => onStatusChange(row, newStatus, 'statut')} chipComponent={StatusChip}
            sx={{width:"120px"}}
          />
        );        
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover selected={selected} style={{ cursor: "pointer" }}>
      {columns
        .filter((column) => column.id !== "isActive")
        .map((column: any, index: number) => (
          <TableCell
            onDoubleClick={() => handleDetails(row)}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap",
              ...(index === 0 && {position: "relative"}),
              py: column.id === "statut" ? 0 : "inherit" }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.statut) }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof IVehicleAffectation])}
          </TableCell>
        ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEdit(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}

