'use client';
import { Box, Stack, Tabs, Typography } from '@mui/material';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { DrawerControlProps, TableType } from '@/shared/types/common';
import TableManager from '@/shared/components/table/table-manager';
import {
  _consumptionMockList,
  CONSUMPTION_TABLE_HEAD,
} from '@/shared/_mock/flottes/_employee';
import { type TableConfig, useTableManager } from '@/hooks/use-table-manager';
import type { Consumption } from '@/shared/types/flottes/consumption';
import AbnormalConsumptionTableRow from './treated-consumption-table-row';
import { StyledTab, tabsStyles } from '../../../../../theme/css';
import TreatedConsumptionDrawer from './traeted-consumption-details';
import { useState } from 'react';

const fuelConsumptionConfig: TableConfig<Consumption> = {
  initialData: _consumptionMockList,
  defaultTableHead: [...CONSUMPTION_TABLE_HEAD, { id: 'circuit', label: 'Circuit', type: 'text' }],
};

export default function TreatedConsumptionTable({ openDrawer }: DrawerControlProps) {
  const [selectedRowForDrawer, setSelectedRowForDrawer] = useState<Consumption | null>(null)
    
  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    dataToExport
  } = useTableManager<Consumption>(fuelConsumptionConfig);

  const handleRowDoubleClick = (row: Consumption) => {
    setSelectedRowForDrawer(row)
    openDrawer.onTrue()
  }
  const renderRow = (row: Consumption) => (
    <AbnormalConsumptionTableRow
      key={row.id}
      row={row}
      onRowDoubleClick={() => handleRowDoubleClick(row)}
      selected={table.selected.includes(row.id.toString())}
      onSelectRow={() => table.onSelectRow(row.id.toString())}
      columns={tableHead}
      dense={table.dense}
    />
  );

  return (
    <Box>
      <Typography
        variant="h5"
        sx={{
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        Suivie Consommation
      </Typography>
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type={TableType.Mileage}
          activeTab="list"
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
               />
      </Stack>

      <Tabs value={'list'} sx={tabsStyles}>
        <StyledTab value={'list'} label={'Liste des anomalies de consommation du carburant traitées'} />
      </Tabs>

      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={handleFilterChange}
        renderRow={renderRow}
        fixedHeight="calc(100vh - 320px)"
      />
      
      {selectedRowForDrawer ? (
        <TreatedConsumptionDrawer isOpen={openDrawer} onClose={openDrawer.onFalse} rowData={selectedRowForDrawer} />
      ):<></>}
    
    </Box>
  );
}
