import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { _incidents, DEFAULT_INCIDENT_TABLE_HEAD } from '@/shared/_mock/flottes/_Incidents';
import { IIncident, StatutSinistre } from '@/shared/types/flottes/incident';
import { useMemo } from 'react';

const incidentConfig: TableConfig<IIncident> = {
  initialData: _incidents,
  defaultTableHead: DEFAULT_INCIDENT_TABLE_HEAD,
};

export function useIncidentTable() {
  const tableManager = useTableManager<IIncident>(incidentConfig);
  
  const filteredDataWithoutReparation = useMemo(() => {
    return tableManager.filteredData.filter(
      incident => incident.statut !== StatutSinistre.Reparation
    );
  }, [tableManager.filteredData]);

  return {
    ...tableManager,
    filteredData: filteredDataWithoutReparation,
  };
}