import { StatusColor } from "./utils/schedule-utils"

export interface Driver {
  id: string
  name: string
  company: string
  vehicleId: string
  immatricule:string
  vehicleName?:string
}

export interface TimeSlot {
  id: string
  driverId: string
  startDate: string
  endDate: string
  date?: string
  startHeure?: string
  startMinute?: string
  endHeure?: string
  endMinute?: string
  color: string
  status?: string
  hasStartLocation?: boolean
  hasEndLocation?: boolean
}

export interface ScheduleData {
  drivers: Driver[]
  timeSlots: TimeSlot[]
}

export interface DraggableTimeSlotProps {
  slot: TimeSlot
  width: number
  top: number
  height: string | number
  handlePopoverOpenT: (event: React.MouseEvent<HTMLElement>, slot: TimeSlot) => void
  handlePopoverCloseT: () => void
  onDoubleClick: (event: React.MouseEvent<HTMLElement>) => void
}

export interface DriverDetail {
  icon: any;
  label: string;
  value: string;
}

export interface DroppableCellProps {
  driverId: string;
  children: React.ReactNode;
  height: number;
  zoomLevel?: number;
}