import { TableConfig, useTableManager } from "@/hooks/use-table-manager";
import { _leaves, LEAVE_TABLE_COLUMNS } from "@/shared/_mock/_conge";

import { TableType } from "@/shared/types/common";
import { ILeave } from "@/shared/types/leave";

const congeConfig: TableConfig<ILeave> = {
    type: TableType.Conge,
    initialData: _leaves,
    defaultTableHead: LEAVE_TABLE_COLUMNS,
  };
  
  export function useCongeTable() {
    return useTableManager<ILeave>(congeConfig);
  }