import { TableConfig, useTableManager } from "@/hooks/use-table-manager";
import { _absence, ABSENCE_TABLE_COLUMNS } from "@/shared/_mock/_absences";
import { _leaves} from "@/shared/_mock/_conge";


import { TableType } from "@/shared/types/common";
import { IDemandeAbsence } from "@/shared/types/leave";

const absenceConfig: TableConfig<IDemandeAbsence> = {
    type: TableType.DemandeAbsence,
    initialData: _absence,
    defaultTableHead: ABSENCE_TABLE_COLUMNS,
  };
  
  export function useCongeTable() {
    return useTableManager<IDemandeAbsence>(absenceConfig);
  }