import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_LEAVE_DATA } from '@/shared/_mock/_absences';

import { IDemandeAbsence} from '@/shared/types/leave';

const congeConfig: TabConfig<IDemandeAbsence> = {
  type: 'demande',
  listTitle: 'Liste des Demandes',
  newItemTitle: 'Nouvelle Demande',
  initialData: INITIAL_LEAVE_DATA,
  getItemCode: (conge: IDemandeAbsence) => `${conge.requestNumber} - ${conge.leaveType}`,
};

export function useAbsenceTabs() {
  const tabManager = useTabsManager<IDemandeAbsence>(congeConfig);

  const handleSave = async (conge: IDemandeAbsence) => {
    tabManager.handleTabClose(null as any, tabManager.activeTab);
  };

  const handleApprove = async (conge: IDemandeAbsence) => {
    const updatedConge = {
      ...conge,
      statut: 'approuve' as const,
      decision: 'validee' as const,
      dateTraitement: new Date().toISOString(),
    };
    return updatedConge;
  };

  const handleReject = async (conge: IDemandeAbsence) => {
    const updatedConge = {
      ...conge,
      statut: 'refuse' as const,
      decision: 'refusee' as const,
      dateTraitement: new Date().toISOString(),
    };
    return updatedConge;
  };



  const handleDelete = async (conge: IDemandeAbsence) => {
  };

  return {
    ...tabManager,
    handleSave,
    handleApprove,
    handleReject,
    handleDelete,
  };
}