import * as Yup from 'yup';
import { IDemandeAbsence } from '@/shared/types/leave';

export const absenceSchema = Yup.object().shape({
  DemandeType: Yup.string()
    .required('Le type de demande est requis'),
  AbsenceType: Yup.string()
    .when('DemandeType', {
      is: 'Absence',
      then: (schema) => schema.required('Le type d\'absence est requis'),
      otherwise: (schema) => schema.notRequired(),
    }),
  leaveType: Yup.string()
    .when('DemandeType', {
      is: 'Congé',
      then: (schema) => schema.required('Le type de congé est requis'),
      otherwise: (schema) => schema.notRequired(),
    }),
  startDate: Yup.date()
    .required('La date de début est requise')
    .max(new Date(), 'La date de début ne peut pas être dans le futur'),
  endDate: Yup.date()
    .required('La date de fin est requise')
    .min(Yup.ref('startDate'), 'La date de fin doit être postérieure à la date de début'),
  daysCount: Yup.number()
    .required('Le nombre de jours est requis')
    .min(0, 'Le nombre de jours doit être positif'),
  status: Yup.string()
    .required('Le statut est requis'),
  reason: Yup.string()
    .max(500, 'Le motif ne doit pas dépasser 500 caractères'),
}); 