import { FormFieldType } from '@/shared/types/common';
import { IDemandeAbsence } from '@/shared/types/leave';
import { 
  faCalendarDays, 
  faFileLines, 
  faHashtag,
 
} from '@fortawesome/free-solid-svg-icons';

export const LEAVE_TYPES = [
  { value: 'sick_leave', label: 'Congé maladie' },
  { value: 'parental_leave', label: 'Congé parental' },
  { value: 'annual_leave', label: 'Congé annuel' },
  { value: 'unpaid_leave', label: 'Congé sans solde' },
  { value: 'rtt', label: 'RTT' },
];

export const LEAVE_STATUS = [
  { value: 'En attente', label: 'En attente' },
  { value: 'Approuvée', label: 'Approuvée' },
  { value: 'Refusée', label: 'Refusée' },
];

export const LEAVE_DECISION = [
  { value: 'Validée', label: 'Validée' },
  { value: 'Refusée', label: 'Refusée' },
  { value: 'none', label: '' },
];

export const NOTIFICATION_MODES = [
  { value: 'SMS', label: 'SMS' },
  { value: 'Email', label: 'Email' },
  { value: 'Application', label: 'Application' },
];

export const absenceFormFields: FormFieldType<IDemandeAbsence>[] = [
  {
    name: 'requestNumber',
    label: 'Numéro de demande',
    type: 'text',
    required: true,
    icon: faHashtag,
    placeholder: 'Numéro de demande',
  },
  {
    name: 'DemandeType',
    label: 'Type de demande',
    type: 'select',
    required: true,
    icon: faCalendarDays,
    placeholder: 'Sélectionner le type',
    options: [
      { value: 'Absence', label: 'Absence' },
      { value: 'Congé', label: 'Congé' },
    ]
  },
  {
    name: 'leaveType',
    label: 'Type de congé',
    type: 'select',
    required: true,
    icon: faCalendarDays,
    placeholder: 'Sélectionner le type',
    options: [
      { value: 'Congé maladie', label: 'Congé maladie' },
      { value: 'Congé parental', label: 'Congé parental' },
      { value: 'Congé annuel', label: 'Congé annuel' },
      { value: 'Congé sans solde', label: 'Congé sans solde' },
      { value: 'RTT', label: 'RTT' },
      { value: 'Congé payé', label: 'Congé payé' },
    ]
  },
  {
    name: 'AbsenceType',
    label: 'Type d\'absence',
    type: 'select',
    required: true,
    icon: faCalendarDays,
    placeholder: 'Sélectionner le type',
    options: [
      { value: 'Formation professionnelle', label: 'Formation professionnelle' },
      { value: 'Mission externe', label: 'Mission externe' },
      { value: 'Télétravail exceptionnel', label: 'Télétravail exceptionnel' },
      { value: 'Absence autorisée', label: 'Absence autorisée' },
      { value: 'Absence non autorisée', label: 'Absence non autorisée' },
      { value: 'Rendez-vous médical', label: 'Rendez-vous médical' },
 
    
    ]
  },
  
  {
    name: 'reason',
    label: 'Motif (facultatif)',
    type: 'textarea',
    required: false,
    icon: faFileLines,
    placeholder: 'Entrez un motif'
  },
  {
    name: 'startDate',
    label: 'Date de début',
    type: 'date',
    required: true,
  },
  {
    name: 'endDate',
    label: 'Date de fin',
    type: 'date',
    required: true,
  },
  {
    name: 'daysCount',
    label: 'Nombre de jours demandés',
    type: 'number',
    required: true,
    icon: faHashtag,
    placeholder: '0'
  },
 
  {
    name: 'status',
    label: 'Statut',
    type: 'select',
    required: true,
    options: LEAVE_STATUS
  },
];

export const getStatusLabel = (status: string): string => {
  const statusObj = LEAVE_STATUS.find(s => s.value === status);
  return statusObj ? statusObj.label : status;
};

export const getDecisionLabel = (decision: string): string => {
  const decisionObj = LEAVE_DECISION.find(d => d.value === decision);
  return decisionObj ? decisionObj.label : decision;
};

export const getLeaveTypeLabel = (type: string): string => {
  const typeObj = LEAVE_TYPES.find(t => t.value === type);
  return typeObj ? typeObj.label : type;
};

