import React from 'react';
import TableManager from '../../../components/table/table-manager';
import { TableColumn } from '@/shared/types/common';
import UsagerTableRow from '../view/usager-table-row';
import { IPassengerList } from '@/shared/types/passenger';

interface UsagerTableProps {
  filteredData: IPassengerList[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: IPassengerList) => void;
  handleView: (item: IPassengerList) => void;
  handleCopy: (item: IPassengerList) => void;
  onStatusChange: (row: IPassengerList, newStatus: string, field: keyof IPassengerList) => void;
  loading: boolean;
}

export default function UsagerTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  handleCopy,
  onStatusChange,
  loading
}: UsagerTableProps) {
  const renderRow = (row: IPassengerList) => (
    <UsagerTableRow
      dense={table.dense}
      key={row.id}
      row={row}
      handleEdit={handleEdit}
      handleCopy={handleCopy}
      handleDetails={handleView}
      columns={tableHead.slice(0, -1)}
      onStatusChange={onStatusChange}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      loading={loading}
    />
  );
}

