import { _BINARY_Qst } from '@/shared/_mock/_trajets';
import { FormFieldType } from '@/shared/types/common';
import { Civility, IRepresentative, RelationType } from '@/shared/types/usager';
import { faEnvelope, faMobileScreenButton, faPhone, faPhoneFlip, faStickyNote, faStopwatch, faUserTie, faVoicemail } from '@fortawesome/free-solid-svg-icons';
import { _CIVILITE } from './form-fields-usager';

  export const _CIVILITE_OPTIONS = [
    { value: Civility.M, label: "M." },
    { value: Civility.MME, label: "Mme." },
    { value: Civility.M_MME, label: "M.Mme." },
    { value: Civility.MM, label: "MM." },
    { value: Civility.MMES, label: "Mmes." },
    { value: Civility.AUTRE, label: "Autre" },
  ];
  export const _REPRESENTANT_TYPE = [
    { value: RelationType.MERE, label: 'Mère' },
    { value: RelationType.PERE, label: 'Père' },
    { value: RelationType.GRANDS_PARENTS, label: 'Grands-parents' },
    { value: RelationType.FOYER_DE_VIE, label: 'Foyer de vie' },
    { value: RelationType.ETABLISSEMENT_MEDICAL, label: 'Établissement médico-social' },
    { value: RelationType.AUTRE, label: 'Autre' },
  ];

export const mainRepresentantformFields: FormFieldType<IRepresentative>[] = [
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    options: _REPRESENTANT_TYPE,
  },
  {
    name: 'civilite',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE_OPTIONS,
  },
  {
    name: 'firstName',
    label: 'Nom parent',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'lastName',
    label: 'Prénom Parent',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'address',
    label: 'Address',
    type: 'address',
    required: true,
  },
];

export const contactFormFields: FormFieldType<IRepresentative>[] = [
  {
    name: 'mobile',
    label: 'Tel mobile',
    placeholder: 'Entrez un tel mobile',
    type: 'text',
    icon: faMobileScreenButton,
  },
  {
    name: 'fixe',
    label: 'Tel Fixe',
    placeholder: 'Entrez une tel fixe',
    type: 'text',
    icon: faPhoneFlip,
  },
  {
    name: 'personne',
    label: 'Personne',
    placeholder: 'Entrez un text',
    type: 'text',
    icon: faUserTie,
  },
  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    required: true,
    icon: faEnvelope,
  },
  {
    name: 'circuit',
    label: 'Circuit',
    placeholder: 'Entrez un text',
    type: 'text',
    icon: '/assets/icons/menu/ic_exploitation.svg',
  },
  {
    name: 'adresseEtablissement',
    label: 'Prise en charge',
    type: 'address',
    required: true,
  },
  {
    name: 'autoParentale',
    label: 'Auto. parentale',
    type: 'checkbox',
    options: _BINARY_Qst,
  },
  {
    name: 'notificationArivee',
    label: "Notification d'arivee",
    type: 'checkbox',    
    options: _BINARY_Qst,
  },
];

export const interlocuteursFormFields: FormFieldType<IRepresentative>[] = [
  {
    name: 'civilite',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE,
  },
  {
    name: 'firstName',
    label: 'Nom',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'lastName',
    label: 'Prénom',
    placeholder: 'Entrez un prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'mobile',
    label: 'Tel mobile',
    placeholder: 'Entrez un tel',
    type: 'text',
    icon: faMobileScreenButton,
  },
  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    icon: faEnvelope,
  },
  {
    name: 'type',
    label: 'Type',
    placeholder: 'Choisissez une valeur',
    type: 'select',
    options: _REPRESENTANT_TYPE,
  },
  {
    name: 'observation',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
];
