// shared/types/attendance-sheet.ts

export enum Months {
  Janvier = 'Janvier',
  Février = 'Février',
  Mars = 'Mars',
  Avril = 'Avril',
  Mai = 'Mai',
  Juin = 'Juin',
  Juillet = 'Juillet',
  Août = 'Août',
  Septembre = 'Septembre',
  Octobre = 'Octobre',
  Novembre = 'Novembre',
  Décembre = 'Décembre',
}

export enum AttendanceSheetStatus {
  ACTIVE = 'ACTIVE',
  INACTIVE = 'INACTIVE', // Correction de l'orthographe
}

export const attendanceSheetStatusLabelsFr: Record<AttendanceSheetStatus, string> = {
  [AttendanceSheetStatus.ACTIVE]: 'Actif',
  [AttendanceSheetStatus.INACTIVE]: 'Inactif',
};

export interface AttendanceSheet {
  id: string;
  number: string;
  year: number;
  month: string | number;
  departmentId: number;
  departmentName: string | null;
  circuitId: string;
  circuitName: string | null;
  status: AttendanceSheetStatus;
  presenceDaysCount: number;
  absenceDaysCount: number;
  schoolDaysCount: number;
  transportArCount: number;
  createdAt: string;
  updatedAt: string;
  isActive: boolean;
}

export interface AttendanceSheetList {
  content: AttendanceSheet[];
  totalElements: number;
  totalPages: number;
  page: number;
  size: number;
}

export interface AttendanceSheetPageFilterParams {
  number?: string;
  circuitName?: string;
  departmentName?: string;
  year?: number;
  month?: string | number | Months;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  status?: AttendanceSheetStatus;
}

export interface AttendanceSheetRequest {
  id?: string;
  number: string;
  year: number;
  month: string | number;
  departmentId: number;
  circuitId: string;
  status?: AttendanceSheetStatus;
  presenceDaysCount?: number;
  absenceDaysCount?: number;
  schoolDaysCount?: number;
  transportArCount?: number;
  isActive?: boolean;
}

export interface AttendanceSheetSearchDetails {
  id: string;
  nomCircuit?: string;
  departement?: string;
  mois?: string | Months;
  annee?: string | number;
  nom?: string;
  prenom?: string;
  etablissement?: string;
  telephone?: string;
  joursClasse?: string | number;
  joursPresence?: string | number;
  joursAbsence?: string | number;
  transportAR?: string | number;
  completionDate?: string;
  nomResponsable?: string;
}

export const mapAttendanceSheetToRequest = (sheet: AttendanceSheet): AttendanceSheetRequest => {
  return {
    id: sheet.id,
    number: sheet.number,
    year: sheet.year,
    month: sheet.month,
    departmentId: sheet.departmentId,
    circuitId: sheet.circuitId,
    status: sheet.status,
    presenceDaysCount: sheet.presenceDaysCount,
    absenceDaysCount: sheet.absenceDaysCount,
    schoolDaysCount: sheet.schoolDaysCount,
    transportArCount: sheet.transportArCount,
    isActive: sheet.isActive,
  };
};