import type { TableColumn } from "@/shared/types/common"

export enum AutomationFrequency {
  QUOTIDIEN = "QUOTIDIEN",
  HEBDOMADAIRE = "HEBDOMADAIRE",
  MENSUEL = "MENSUEL",
  ANNUEL = "ANNUEL",
}

export enum AutomationEvent {
  ANNIVERSAIRE_EMPLOYE = "ANNIVERSAIRE_EMPLOYE",
  FIN_CONTRAT = "FIN_CONTRAT",
  RAPPEL_REUNION = "RAPPEL_REUNION",
  AUTRE = "AUTRE",
}

export interface IEmailAutomation {
  id: string
  nom: string
  templateId: string
  templateTitre: string
  declencheur: {
    type: "FREQUENCE" | "EVENEMENT"
    frequence?: AutomationFrequency
    evenement?: AutomationEvent
  }
  destinataires: {
    type: "GROUPE" | "INDIVIDU"
    groupes?: string[]
    individus?: string[]
  }
  heureEnvoi: string
  dernierEnvoi?: string
  isArchive: boolean
}

export interface IEmailAutomationFilter {
  nom?: string
  templateId?: string
  declencheurType?: "FREQUENCE" | "EVENEMENT"
  frequence?: AutomationFrequency
  evenement?: AutomationEvent
}

export const INITIAL_EMAIL_AUTOMATION_DATA: IEmailAutomation = {
  id: "",
  nom: "",
  templateId: "",
  templateTitre: "",
  declencheur: {
    type: "FREQUENCE",
    frequence: AutomationFrequency.QUOTIDIEN,
  },
  destinataires: {
    type: "GROUPE",
    groupes: [],
  },
  heureEnvoi: "09:00",
  isArchive: false,
}

export const DEFAULT_EMAIL_AUTOMATION_TABLE_HEAD: TableColumn[] = [
  { id: "nom", label: "Nom de la règle", type: "text" },
  { id: "templateTitre", label: "Modèle associé", type: "text" },
  { id: "declencheur", label: "Déclencheur", type: "text" },
  { id: "dernierEnvoi", label: "Dernier envoi", type: "datetime" },
]
