import { AddressData } from "./common"
import type { Civility } from "./usager"
import { ZoneType } from "./vacance"

export enum RegimeType {
  prive = "prive",
  public = "public",
}

export enum EstablishmentType {
  primaire = "Primaire",
  college = "Collège",
  lycee = "Lycée",
}

export interface IResponsableEtablissement {
  id: string
  civilite: Civility
  firstName: string
  lastName: string
  telephone: string
  email: string
}

export interface IEtablissement {
  id: string
  nomEtablissement: string
  adresse: AddressData
  regime: RegimeType
  type: string
  codeUAI: string
  horaire: string
  telephone: string
  colorCode?: string
  telephoneFax?: string
  email?: string
  password?: string
  siteWeb?: string
  observation?: string
  idDO?: string
  codeDO?: string
  responsable: IResponsableEtablissement
  isActive?: boolean
  zone?: ZoneType,
  department:Departements
}

export interface IAttendance {
  circuit: string
  circuitType: string
  month: string
  year: string
}

export type IAttendanceSheet = {
  id: string;
  number: string;
  circuitName: string;
  departmentName: Departements;
  year: string;
  month: string;
  isActive?: boolean;
};
export interface IAttendanceSheetCher {
  id: string;
  nomCircuit?: string;
  departement?: string;
  mois?: string;
  annee?: string;  
  nom?: string;
  prenom?: string;
  
  etablissement?: string;
  adresse?: string;
  telephone?: string;
  
  joursClasse?: string;
  joursPresence?: string;
  joursAbsence?: string;
  transportAR?: string;
  
  completionDate?: string;
  nomResponsable?: string;
}

export interface IAttendanceNotCher {
  departement?: string;
  mois?: string;
  annee?: string; 
   
  transporteur?: string
  circuit?: string
  etablissement?: string
  

  eleveA?: string
  eleveB?: string
  eleveC?: string
  eleveD?: string
  eleveE?: string

  observation?: string
}



export enum Months {
  Janvier = "Janvier",
  Février = "Février",
  Mars = "Mars",
  Avril = "Avril",
  Mai = "Mai",
  Juin = "Juin",
  Juillet = "Juillet",
  Août = "Août",
  Septembre = "Septembre",
  Octobre = "Octobre",
  Novembre = "Novembre",
  Décembre = "Décembre",
}

export enum Departements {
  Gironde = "Gironde",
  Landes = "Landes",
  Dordogne = "Dordogne",
  Côte_dOr = "Côte-d'Or",
  Aveyron = "Aveyron",
  Saône_et_Loire = "Saône-et-Loire",
  Marne = "Marne",
  Puy_de_Dôme = "Puy-de-Dôme",
  Cher = "Cher",
  Maine_et_Loire = "Maine-et-Loire",
}