export type LeaveType = 
  | 'Congé maladie' 
  | 'Congé parental'
  | 'Congé annuel'
  | 'Congé sans solde'
  | 'RTT'
  | 'Congé payé';

  export type AbsenceType = 
  | 'Congé maladie' 
  | 'Congé parental'
  | 'Congé annuel'
  | 'Congé sans solde'
  | 'RTT'

export type DemandeType = 
  | 'Absence'
  | 'Congé';

export type LeaveStatus = 
  | 'En attente'
  | 'Approuvée'
  | 'Refusée';


export type NotificationMode = 
  | 'SMS'
  | 'Email'
  | 'Application';

export interface ILeaveHistory {
  date: string;
  action: string;
  user: string;
  comment: string;
}

export interface ILeave {
  isActive: boolean | undefined;
  id: string;
  employeeName: string;
  submissionDate: string;
  leaveType: LeaveType;
  startDate: string;
  endDate: string;
  status: LeaveStatus;
  processDate: string;
  notificationMode: NotificationMode;
  reason: string;
  daysCount: number;
  employeeId: string;
  history: ILeaveHistory[];
  dateDebut?: string;
  dateFin?: string;
  dateSubmission?: string;
  dateTraitement?: string;
  type?: LeaveType;
  modeReception?: NotificationMode;
  
}

export interface IDemandeAbsence {
  isActive: boolean | undefined;
  id: string;
  requestNumber: string;
  submissionDate: string;
  DemandeType: DemandeType;
  leaveType: LeaveType;
  AbsenceType: LeaveType;
  startDate: string;
  endDate: string;          
  status: LeaveStatus;
  processDate: string;
  reason: string;
  daysCount: number;
  employeeId: string;
  dateDebut?: string;
  dateFin?: string;
  dateSubmission?: string;
  dateTraitement?: string;
  type?: LeaveType;
  readOnly?: boolean;
  disabled?: boolean;
}