export enum Permission {
    /** Appel d'offre */
    APPEL_OFFRE = "APPEL_OFFRE",
    APPEL_OFFRE_DELETE = "APPEL_OFFRE:DELETE",
    APPEL_OFFRE_MODIFY = "APPEL_OFFRE:MODIFY",
    APPEL_OFFRE_READ = "APPEL_OFFRE:READ",
    APPEL_OFFRE_WRITE = "APPEL_OFFRE:WRITE",
    /** Configuration Admin */
    CONFIGURATION_ADMIN = "CONFIGURATION_ADMIN",
    /** Agent et Rôle */
    CONFIGURATION_ADMIN_AGENT_ET_ROLE = "CONFIGURATION_ADMIN:AGENT_ET_ROLE",
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE = "CONFIGURATION_ADMIN:AGENT_ET_ROLE:DELETE",
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY = "CONFIGURATION_ADMIN:AGENT_ET_ROLE:MODIFY",
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ = "CONFIGURATION_ADMIN:AGENT_ET_ROLE:READ",
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE = "CONFIGURATION_ADMIN:AGENT_ET_ROLE:WRITE",
    /** Gestion Email */
    CONFIGURATION_ADMIN_GESTION_EMAIL = "CONFIGURATION_ADMIN:GESTION_EMAIL",
    CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE = "CONFIGURATION_ADMIN:GESTION_EMAIL:DELETE",
    CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY = "CONFIGURATION_ADMIN:GESTION_EMAIL:MODIFY",
    CONFIGURATION_ADMIN_GESTION_EMAIL_READ = "CONFIGURATION_ADMIN:GESTION_EMAIL:READ",
    CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE = "CONFIGURATION_ADMIN:GESTION_EMAIL:WRITE",
    /** Infrastructure */
    CONFIGURATION_ADMIN_INFRASTRUCTURE = "CONFIGURATION_ADMIN:INFRASTRUCTURE",
    CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE = "CONFIGURATION_ADMIN:INFRASTRUCTURE:DELETE",
    CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY = "CONFIGURATION_ADMIN:INFRASTRUCTURE:MODIFY",
    CONFIGURATION_ADMIN_INFRASTRUCTURE_READ = "CONFIGURATION_ADMIN:INFRASTRUCTURE:READ",
    CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE = "CONFIGURATION_ADMIN:INFRASTRUCTURE:WRITE",
    /** Exploitation */
    EXPLOITATION = "EXPLOITATION",
    /** Chauffeur */
    EXPLOITATION_CHAUFFEUR = "EXPLOITATION:CHAUFFEUR",
    /** Absence */
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR = "EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR",
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_DELETE = "EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:DELETE",
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_MODIFY = "EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:MODIFY",
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_READ = "EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:READ",
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_WRITE = "EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:WRITE",
    /** Feuille de Route */
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE = "EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE",
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_DELETE = "EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:DELETE",
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_MODIFY = "EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:MODIFY",
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_READ = "EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:READ",
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_WRITE = "EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:WRITE",
    /** Liste Chauffeur */
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR = "EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR",
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_DELETE = "EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:DELETE",
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_MODIFY = "EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:MODIFY",
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_READ = "EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:READ",
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_WRITE = "EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:WRITE",
    /** Planning Chauffeur */
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR = "EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR",
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_DELETE = "EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:DELETE",
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_MODIFY = "EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:MODIFY",
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_READ = "EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:READ",
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_WRITE = "EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:WRITE",
    /** Suivi Trajet */
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET = "EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET",
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_DELETE = "EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:DELETE",
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_MODIFY = "EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:MODIFY",
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_READ = "EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:READ",
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_WRITE = "EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:WRITE",
    /** Circuit / Usager */
    EXPLOITATION_CIRCUIT_USAGER = "EXPLOITATION:CIRCUIT_USAGER",
    /** Absence */
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE = "EXPLOITATION:CIRCUIT_USAGER:ABSENCE",
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_DELETE = "EXPLOITATION:CIRCUIT_USAGER:ABSENCE:DELETE",
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_MODIFY = "EXPLOITATION:CIRCUIT_USAGER:ABSENCE:MODIFY",
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_READ = "EXPLOITATION:CIRCUIT_USAGER:ABSENCE:READ",
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_WRITE = "EXPLOITATION:CIRCUIT_USAGER:ABSENCE:WRITE",
    /** Avenant */
    EXPLOITATION_CIRCUIT_USAGER_AVENANT = "EXPLOITATION:CIRCUIT_USAGER:AVENANT",
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_DELETE = "EXPLOITATION:CIRCUIT_USAGER:AVENANT:DELETE",
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_MODIFY = "EXPLOITATION:CIRCUIT_USAGER:AVENANT:MODIFY",
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_READ = "EXPLOITATION:CIRCUIT_USAGER:AVENANT:READ",
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_WRITE = "EXPLOITATION:CIRCUIT_USAGER:AVENANT:WRITE",
    /** Circuit */
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT = "EXPLOITATION:CIRCUIT_USAGER:CIRCUIT",
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_DELETE = "EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:DELETE",
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_MODIFY = "EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:MODIFY",
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_READ = "EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:READ",
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_WRITE = "EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:WRITE",
    /** Trajet */
    EXPLOITATION_CIRCUIT_USAGER_TRAJET = "EXPLOITATION:CIRCUIT_USAGER:TRAJET",
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_DELETE = "EXPLOITATION:CIRCUIT_USAGER:TRAJET:DELETE",
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_MODIFY = "EXPLOITATION:CIRCUIT_USAGER:TRAJET:MODIFY",
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_READ = "EXPLOITATION:CIRCUIT_USAGER:TRAJET:READ",
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_WRITE = "EXPLOITATION:CIRCUIT_USAGER:TRAJET:WRITE",
    /** Usager */
    EXPLOITATION_CIRCUIT_USAGER_USAGER = "EXPLOITATION:CIRCUIT_USAGER:USAGER",
    EXPLOITATION_CIRCUIT_USAGER_USAGER_DELETE = "EXPLOITATION:CIRCUIT_USAGER:USAGER:DELETE",
    EXPLOITATION_CIRCUIT_USAGER_USAGER_MODIFY = "EXPLOITATION:CIRCUIT_USAGER:USAGER:MODIFY",
    EXPLOITATION_CIRCUIT_USAGER_USAGER_READ = "EXPLOITATION:CIRCUIT_USAGER:USAGER:READ",
    EXPLOITATION_CIRCUIT_USAGER_USAGER_WRITE = "EXPLOITATION:CIRCUIT_USAGER:USAGER:WRITE",
    /** Client */
    EXPLOITATION_CLIENT = "EXPLOITATION:CLIENT",
    EXPLOITATION_CLIENT_DELETE = "EXPLOITATION:CLIENT:DELETE",
    EXPLOITATION_CLIENT_MODIFY = "EXPLOITATION:CLIENT:MODIFY",
    EXPLOITATION_CLIENT_READ = "EXPLOITATION:CLIENT:READ",
    EXPLOITATION_CLIENT_WRITE = "EXPLOITATION:CLIENT:WRITE",
    /** Contrat */
    EXPLOITATION_CONTRAT = "EXPLOITATION:CONTRAT",
    EXPLOITATION_CONTRAT_DELETE = "EXPLOITATION:CONTRAT:DELETE",
    EXPLOITATION_CONTRAT_MODIFY = "EXPLOITATION:CONTRAT:MODIFY",
    EXPLOITATION_CONTRAT_READ = "EXPLOITATION:CONTRAT:READ",
    EXPLOITATION_CONTRAT_WRITE = "EXPLOITATION:CONTRAT:WRITE",
    /** Etablissement */
    EXPLOITATION_ETABLISSEMENT = "EXPLOITATION:ETABLISSEMENT",
    /** Feuille de Présence */
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE = "EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE",
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_DELETE = "EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:DELETE",
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_MODIFY = "EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:MODIFY",
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_READ = "EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:READ",
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_WRITE = "EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:WRITE",
    /** Liste Établissement */
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT = "EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT",
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_DELETE = "EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:DELETE",
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_MODIFY = "EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:MODIFY",
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_READ = "EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:READ",
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_WRITE = "EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:WRITE",
    /** Vacance / Jour Férié */
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE = "EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE",
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_DELETE = "EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:DELETE",
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_MODIFY = "EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:MODIFY",
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_READ = "EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:READ",
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_WRITE = "EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:WRITE",
    /** Préparation */
    EXPLOITATION_PREPARATION = "EXPLOITATION:PREPARATION",
    /** Préparation Chauffeur */
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR = "EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR",
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_DELETE = "EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:DELETE",
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_MODIFY = "EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:MODIFY",
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_READ = "EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:READ",
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_WRITE = "EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:WRITE",
    /** Préparation Circuit */
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT = "EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT",
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_DELETE = "EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:DELETE",
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_MODIFY = "EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:MODIFY",
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_READ = "EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:READ",
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_WRITE = "EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:WRITE",
    /** Préparation Usager */
    EXPLOITATION_PREPARATION_PREPARATION_USAGER = "EXPLOITATION:PREPARATION:PREPARATION_USAGER",
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_DELETE = "EXPLOITATION:PREPARATION:PREPARATION_USAGER:DELETE",
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_MODIFY = "EXPLOITATION:PREPARATION:PREPARATION_USAGER:MODIFY",
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_READ = "EXPLOITATION:PREPARATION:PREPARATION_USAGER:READ",
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_WRITE = "EXPLOITATION:PREPARATION:PREPARATION_USAGER:WRITE",
    /** Facturation et Paiement */
    FACTURATION_PAIEMENT = "FACTURATION_PAIEMENT",
    FACTURATION_PAIEMENT_DELETE = "FACTURATION_PAIEMENT:DELETE",
    FACTURATION_PAIEMENT_MODIFY = "FACTURATION_PAIEMENT:MODIFY",
    FACTURATION_PAIEMENT_READ = "FACTURATION_PAIEMENT:READ",
    FACTURATION_PAIEMENT_WRITE = "FACTURATION_PAIEMENT:WRITE",
    /** Flottes */
    FLOTTES = "FLOTTES",
    /** Carburant et Consommation */
    FLOTTES_CARBURANT_CONSOMMATION = "FLOTTES:CARBURANT_CONSOMMATION",
    /** Anomalie traitée */
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE = "FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE",
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_DELETE = "FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:DELETE",
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_MODIFY = "FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:MODIFY",
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_READ = "FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:READ",
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_WRITE = "FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:WRITE",
    /** Suivi Carburant */
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_DELETE = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:DELETE",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_MODIFY = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:MODIFY",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_READ = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:READ",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_WRITE = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:WRITE",
    /** Suivi Kilométrage */
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_DELETE = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:DELETE",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_MODIFY = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:MODIFY",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_READ = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:READ",
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_WRITE = "FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:WRITE",
    /** Entretien */
    FLOTTES_ENTRETIEN = "FLOTTES:ENTRETIEN",
    FLOTTES_ENTRETIEN_DELETE = "FLOTTES:ENTRETIEN:DELETE",
    FLOTTES_ENTRETIEN_MODIFY = "FLOTTES:ENTRETIEN:MODIFY",
    FLOTTES_ENTRETIEN_READ = "FLOTTES:ENTRETIEN:READ",
    FLOTTES_ENTRETIEN_WRITE = "FLOTTES:ENTRETIEN:WRITE",
    /** Incidents */
    FLOTTES_INCIDENTS = "FLOTTES:INCIDENTS",
    FLOTTES_INCIDENTS_DELETE = "FLOTTES:INCIDENTS:DELETE",
    FLOTTES_INCIDENTS_MODIFY = "FLOTTES:INCIDENTS:MODIFY",
    FLOTTES_INCIDENTS_READ = "FLOTTES:INCIDENTS:READ",
    FLOTTES_INCIDENTS_WRITE = "FLOTTES:INCIDENTS:WRITE",
    /** Véhicule */
    FLOTTES_VEHICULE = "FLOTTES:VEHICULE",
    FLOTTES_VEHICULE_DELETE = "FLOTTES:VEHICULE:DELETE",
    FLOTTES_VEHICULE_MODIFY = "FLOTTES:VEHICULE:MODIFY",
    FLOTTES_VEHICULE_READ = "FLOTTES:VEHICULE:READ",
    FLOTTES_VEHICULE_WRITE = "FLOTTES:VEHICULE:WRITE",
    /** Géolocalisation */
    GEOLOCALISATION = "GEOLOCALISATION",
    GEOLOCALISATION_DELETE = "GEOLOCALISATION:DELETE",
    GEOLOCALISATION_MODIFY = "GEOLOCALISATION:MODIFY",
    GEOLOCALISATION_READ = "GEOLOCALISATION:READ",
    GEOLOCALISATION_WRITE = "GEOLOCALISATION:WRITE",
    /** Planning */
    PLANNING = "PLANNING",
    /** Planning Chauffeur */
    PLANNING_PLANNING_CHAUFFEUR = "PLANNING:PLANNING_CHAUFFEUR",
    PLANNING_PLANNING_CHAUFFEUR_DELETE = "PLANNING:PLANNING_CHAUFFEUR:DELETE",
    PLANNING_PLANNING_CHAUFFEUR_MODIFY = "PLANNING:PLANNING_CHAUFFEUR:MODIFY",
    PLANNING_PLANNING_CHAUFFEUR_READ = "PLANNING:PLANNING_CHAUFFEUR:READ",
    PLANNING_PLANNING_CHAUFFEUR_WRITE = "PLANNING:PLANNING_CHAUFFEUR:WRITE",
    /** Planning de Location */
    PLANNING_PLANNING_LOCATION = "PLANNING:PLANNING_LOCATION",
    PLANNING_PLANNING_LOCATION_DELETE = "PLANNING:PLANNING_LOCATION:DELETE",
    PLANNING_PLANNING_LOCATION_MODIFY = "PLANNING:PLANNING_LOCATION:MODIFY",
    PLANNING_PLANNING_LOCATION_READ = "PLANNING:PLANNING_LOCATION:READ",
    PLANNING_PLANNING_LOCATION_WRITE = "PLANNING:PLANNING_LOCATION:WRITE",
    /** Planning Véhicule */
    PLANNING_PLANNING_VEHICULE = "PLANNING:PLANNING_VEHICULE",
    PLANNING_PLANNING_VEHICULE_DELETE = "PLANNING:PLANNING_VEHICULE:DELETE",
    PLANNING_PLANNING_VEHICULE_MODIFY = "PLANNING:PLANNING_VEHICULE:MODIFY",
    PLANNING_PLANNING_VEHICULE_READ = "PLANNING:PLANNING_VEHICULE:READ",
    PLANNING_PLANNING_VEHICULE_WRITE = "PLANNING:PLANNING_VEHICULE:WRITE",
    /** RH */
    RH = "RH",
    /** Document */
    RH_DOCUMENT = "RH:DOCUMENT",
    RH_DOCUMENT_DELETE = "RH:DOCUMENT:DELETE",
    RH_DOCUMENT_MODIFY = "RH:DOCUMENT:MODIFY",
    RH_DOCUMENT_READ = "RH:DOCUMENT:READ",
    RH_DOCUMENT_WRITE = "RH:DOCUMENT:WRITE",
    /** Gestion Absence */
    RH_GESTION_ABSENCE = "RH:GESTION_ABSENCE",
    RH_GESTION_ABSENCE_DELETE = "RH:GESTION_ABSENCE:DELETE",
    RH_GESTION_ABSENCE_MODIFY = "RH:GESTION_ABSENCE:MODIFY",
    RH_GESTION_ABSENCE_READ = "RH:GESTION_ABSENCE:READ",
    RH_GESTION_ABSENCE_WRITE = "RH:GESTION_ABSENCE:WRITE",
    /** Gestion de Calendrier */
    RH_GESTION_DE_CALENDRIER = "RH:GESTION_DE_CALENDRIER",
    RH_GESTION_DE_CALENDRIER_DELETE = "RH:GESTION_DE_CALENDRIER:DELETE",
    RH_GESTION_DE_CALENDRIER_MODIFY = "RH:GESTION_DE_CALENDRIER:MODIFY",
    RH_GESTION_DE_CALENDRIER_READ = "RH:GESTION_DE_CALENDRIER:READ",
    RH_GESTION_DE_CALENDRIER_WRITE = "RH:GESTION_DE_CALENDRIER:WRITE",
    /** Gestion de Congé */
    RH_GESTION_DE_CONGE = "RH:GESTION_DE_CONGE",
    RH_GESTION_DE_CONGE_DELETE = "RH:GESTION_DE_CONGE:DELETE",
    RH_GESTION_DE_CONGE_MODIFY = "RH:GESTION_DE_CONGE:MODIFY",
    RH_GESTION_DE_CONGE_READ = "RH:GESTION_DE_CONGE:READ",
    RH_GESTION_DE_CONGE_WRITE = "RH:GESTION_DE_CONGE:WRITE",
    /** Gestion de Salariés */
    RH_GESTION_DE_SALARIES = "RH:GESTION_DE_SALARIES",
    RH_GESTION_DE_SALARIES_DELETE = "RH:GESTION_DE_SALARIES:DELETE",
    RH_GESTION_DE_SALARIES_MODIFY = "RH:GESTION_DE_SALARIES:MODIFY",
    RH_GESTION_DE_SALARIES_READ = "RH:GESTION_DE_SALARIES:READ",
    RH_GESTION_DE_SALARIES_WRITE = "RH:GESTION_DE_SALARIES:WRITE",
    /** Gestion recrutement */
    RH_GESTION_RECRUTEMENT = "RH:GESTION_RECRUTEMENT",
    /** Besoins Recrutement */
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT = "RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT",
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_DELETE = "RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:DELETE",
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_MODIFY = "RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:MODIFY",
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_READ = "RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:READ",
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_WRITE = "RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:WRITE",
    /** Candidature chauffeur */
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR = "RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_DELETE = "RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:DELETE",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_MODIFY = "RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:MODIFY",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_READ = "RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:READ",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_WRITE = "RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:WRITE",
    /** Candidature sédentaire */
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE = "RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_DELETE = "RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:DELETE",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_MODIFY = "RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:MODIFY",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_READ = "RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:READ",
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_WRITE = "RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:WRITE",
    /** RDV annuel */
    RH_RDV_ANNUEL = "RH:RDV_ANNUEL",
    RH_RDV_ANNUEL_DELETE = "RH:RDV_ANNUEL:DELETE",
    RH_RDV_ANNUEL_MODIFY = "RH:RDV_ANNUEL:MODIFY",
    RH_RDV_ANNUEL_READ = "RH:RDV_ANNUEL:READ",
    RH_RDV_ANNUEL_WRITE = "RH:RDV_ANNUEL:WRITE",
    /** Staff */
    STAFF = "STAFF",
    /** Gestion des documents */
    STAFF_GESTION_DOCUMENTS = "STAFF:GESTION_DOCUMENTS",
    STAFF_GESTION_DOCUMENTS_DELETE = "STAFF:GESTION_DOCUMENTS:DELETE",
    STAFF_GESTION_DOCUMENTS_MODIFY = "STAFF:GESTION_DOCUMENTS:MODIFY",
    STAFF_GESTION_DOCUMENTS_READ = "STAFF:GESTION_DOCUMENTS:READ",
    STAFF_GESTION_DOCUMENTS_WRITE = "STAFF:GESTION_DOCUMENTS:WRITE",
  }
  
  export const PermissionHierarchy: Record<Permission, Permission[]> = {
    [Permission.APPEL_OFFRE]: [],
    [Permission.APPEL_OFFRE_DELETE]: [],
    [Permission.APPEL_OFFRE_MODIFY]: [],
    [Permission.APPEL_OFFRE_READ]: [],
    [Permission.APPEL_OFFRE_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE]: [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ, Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE, Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY, Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL]: [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_READ, Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE, Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY, Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_READ]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE]: [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_READ, Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE, Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY, Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_READ]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE]: [],
    [Permission.EXPLOITATION]: [],
    [Permission.EXPLOITATION_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_WRITE]: [],
    [Permission.EXPLOITATION_CLIENT]: [Permission.EXPLOITATION_CLIENT_READ, Permission.EXPLOITATION_CLIENT_WRITE, Permission.EXPLOITATION_CLIENT_MODIFY, Permission.EXPLOITATION_CLIENT_DELETE],
    [Permission.EXPLOITATION_CLIENT_DELETE]: [],
    [Permission.EXPLOITATION_CLIENT_MODIFY]: [],
    [Permission.EXPLOITATION_CLIENT_READ]: [],
    [Permission.EXPLOITATION_CLIENT_WRITE]: [],
    [Permission.EXPLOITATION_CONTRAT]: [Permission.EXPLOITATION_CONTRAT_READ, Permission.EXPLOITATION_CONTRAT_WRITE, Permission.EXPLOITATION_CONTRAT_MODIFY, Permission.EXPLOITATION_CONTRAT_DELETE],
    [Permission.EXPLOITATION_CONTRAT_DELETE]: [],
    [Permission.EXPLOITATION_CONTRAT_MODIFY]: [],
    [Permission.EXPLOITATION_CONTRAT_READ]: [],
    [Permission.EXPLOITATION_CONTRAT_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_WRITE]: [],
    [Permission.FACTURATION_PAIEMENT]: [],
    [Permission.FACTURATION_PAIEMENT_DELETE]: [],
    [Permission.FACTURATION_PAIEMENT_MODIFY]: [],
    [Permission.FACTURATION_PAIEMENT_READ]: [],
    [Permission.FACTURATION_PAIEMENT_WRITE]: [],
    [Permission.FLOTTES]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_WRITE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_WRITE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_WRITE]: [],
    [Permission.FLOTTES_ENTRETIEN]: [Permission.FLOTTES_ENTRETIEN_READ, Permission.FLOTTES_ENTRETIEN_WRITE, Permission.FLOTTES_ENTRETIEN_MODIFY, Permission.FLOTTES_ENTRETIEN_DELETE],
    [Permission.FLOTTES_ENTRETIEN_DELETE]: [],
    [Permission.FLOTTES_ENTRETIEN_MODIFY]: [],
    [Permission.FLOTTES_ENTRETIEN_READ]: [],
    [Permission.FLOTTES_ENTRETIEN_WRITE]: [],
    [Permission.FLOTTES_INCIDENTS]: [Permission.FLOTTES_INCIDENTS_READ, Permission.FLOTTES_INCIDENTS_WRITE, Permission.FLOTTES_INCIDENTS_MODIFY, Permission.FLOTTES_INCIDENTS_DELETE],
    [Permission.FLOTTES_INCIDENTS_DELETE]: [],
    [Permission.FLOTTES_INCIDENTS_MODIFY]: [],
    [Permission.FLOTTES_INCIDENTS_READ]: [],
    [Permission.FLOTTES_INCIDENTS_WRITE]: [],
    [Permission.FLOTTES_VEHICULE]: [Permission.FLOTTES_VEHICULE_READ, Permission.FLOTTES_VEHICULE_WRITE, Permission.FLOTTES_VEHICULE_MODIFY, Permission.FLOTTES_VEHICULE_DELETE],
    [Permission.FLOTTES_VEHICULE_DELETE]: [],
    [Permission.FLOTTES_VEHICULE_MODIFY]: [],
    [Permission.FLOTTES_VEHICULE_READ]: [],
    [Permission.FLOTTES_VEHICULE_WRITE]: [],
    [Permission.GEOLOCALISATION]: [],
    [Permission.GEOLOCALISATION_DELETE]: [],
    [Permission.GEOLOCALISATION_MODIFY]: [],
    [Permission.GEOLOCALISATION_READ]: [],
    [Permission.GEOLOCALISATION_WRITE]: [],
    [Permission.PLANNING]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR]: [Permission.PLANNING_PLANNING_CHAUFFEUR_READ, Permission.PLANNING_PLANNING_CHAUFFEUR_WRITE, Permission.PLANNING_PLANNING_CHAUFFEUR_MODIFY, Permission.PLANNING_PLANNING_CHAUFFEUR_DELETE],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_DELETE]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_MODIFY]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_READ]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_WRITE]: [],
    [Permission.PLANNING_PLANNING_LOCATION]: [Permission.PLANNING_PLANNING_LOCATION_READ, Permission.PLANNING_PLANNING_LOCATION_WRITE, Permission.PLANNING_PLANNING_LOCATION_MODIFY, Permission.PLANNING_PLANNING_LOCATION_DELETE],
    [Permission.PLANNING_PLANNING_LOCATION_DELETE]: [],
    [Permission.PLANNING_PLANNING_LOCATION_MODIFY]: [],
    [Permission.PLANNING_PLANNING_LOCATION_READ]: [],
    [Permission.PLANNING_PLANNING_LOCATION_WRITE]: [],
    [Permission.PLANNING_PLANNING_VEHICULE]: [Permission.PLANNING_PLANNING_VEHICULE_READ, Permission.PLANNING_PLANNING_VEHICULE_WRITE, Permission.PLANNING_PLANNING_VEHICULE_MODIFY, Permission.PLANNING_PLANNING_VEHICULE_DELETE],
    [Permission.PLANNING_PLANNING_VEHICULE_DELETE]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_MODIFY]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_READ]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_WRITE]: [],
    [Permission.RH]: [],
    [Permission.RH_DOCUMENT]: [Permission.RH_DOCUMENT_READ, Permission.RH_DOCUMENT_WRITE, Permission.RH_DOCUMENT_MODIFY, Permission.RH_DOCUMENT_DELETE],
    [Permission.RH_DOCUMENT_DELETE]: [],
    [Permission.RH_DOCUMENT_MODIFY]: [],
    [Permission.RH_DOCUMENT_READ]: [],
    [Permission.RH_DOCUMENT_WRITE]: [],
    [Permission.RH_GESTION_ABSENCE]: [Permission.RH_GESTION_ABSENCE_READ, Permission.RH_GESTION_ABSENCE_WRITE, Permission.RH_GESTION_ABSENCE_MODIFY, Permission.RH_GESTION_ABSENCE_DELETE],
    [Permission.RH_GESTION_ABSENCE_DELETE]: [],
    [Permission.RH_GESTION_ABSENCE_MODIFY]: [],
    [Permission.RH_GESTION_ABSENCE_READ]: [],
    [Permission.RH_GESTION_ABSENCE_WRITE]: [],
    [Permission.RH_GESTION_DE_CALENDRIER]: [Permission.RH_GESTION_DE_CALENDRIER_READ, Permission.RH_GESTION_DE_CALENDRIER_WRITE, Permission.RH_GESTION_DE_CALENDRIER_MODIFY, Permission.RH_GESTION_DE_CALENDRIER_DELETE],
    [Permission.RH_GESTION_DE_CALENDRIER_DELETE]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_MODIFY]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_READ]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_WRITE]: [],
    [Permission.RH_GESTION_DE_CONGE]: [Permission.RH_GESTION_DE_CONGE_READ, Permission.RH_GESTION_DE_CONGE_WRITE, Permission.RH_GESTION_DE_CONGE_MODIFY, Permission.RH_GESTION_DE_CONGE_DELETE],
    [Permission.RH_GESTION_DE_CONGE_DELETE]: [],
    [Permission.RH_GESTION_DE_CONGE_MODIFY]: [],
    [Permission.RH_GESTION_DE_CONGE_READ]: [],
    [Permission.RH_GESTION_DE_CONGE_WRITE]: [],
    [Permission.RH_GESTION_DE_SALARIES]: [Permission.RH_GESTION_DE_SALARIES_READ, Permission.RH_GESTION_DE_SALARIES_WRITE, Permission.RH_GESTION_DE_SALARIES_MODIFY, Permission.RH_GESTION_DE_SALARIES_DELETE],
    [Permission.RH_GESTION_DE_SALARIES_DELETE]: [],
    [Permission.RH_GESTION_DE_SALARIES_MODIFY]: [],
    [Permission.RH_GESTION_DE_SALARIES_READ]: [],
    [Permission.RH_GESTION_DE_SALARIES_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_WRITE]: [],
    [Permission.RH_RDV_ANNUEL]: [Permission.RH_RDV_ANNUEL_READ, Permission.RH_RDV_ANNUEL_WRITE, Permission.RH_RDV_ANNUEL_MODIFY, Permission.RH_RDV_ANNUEL_DELETE],
    [Permission.RH_RDV_ANNUEL_DELETE]: [],
    [Permission.RH_RDV_ANNUEL_MODIFY]: [],
    [Permission.RH_RDV_ANNUEL_READ]: [],
    [Permission.RH_RDV_ANNUEL_WRITE]: [],
    [Permission.STAFF]: [],
    [Permission.STAFF_GESTION_DOCUMENTS]: [Permission.STAFF_GESTION_DOCUMENTS_READ, Permission.STAFF_GESTION_DOCUMENTS_WRITE, Permission.STAFF_GESTION_DOCUMENTS_MODIFY, Permission.STAFF_GESTION_DOCUMENTS_DELETE],
    [Permission.STAFF_GESTION_DOCUMENTS_DELETE]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_MODIFY]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_READ]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_WRITE]: [],
  };

  export const PERMISSION_TRANSLATIONS: Record<string, string> = {
    'DELETE': 'supprimer',
    'MODIFY': 'modifier',
    'READ': 'lire',
    'WRITE': 'ecrire',
  };

export const MODULE_TO_BASE: Record<string, string> = {
    'APPEL_OFFRE': 'Appel d\'offre',
    'APPEL_OFFRE_DELETE': 'Appel d\'offre',
    'APPEL_OFFRE_MODIFY': 'Appel d\'offre',
    'APPEL_OFFRE_READ': 'Appel d\'offre',
    'APPEL_OFFRE_WRITE': 'Appel d\'offre',
    'CONFIGURATION_ADMIN': 'Configuration Admin',
    'CONFIGURATION_ADMIN_AGENT_ET_ROLE': 'Configuration Admin > Agent et Rôle',
    'CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE': 'Configuration Admin > Agent et Rôle',
    'CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY': 'Configuration Admin > Agent et Rôle',
    'CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ': 'Configuration Admin > Agent et Rôle',
    'CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE': 'Configuration Admin > Agent et Rôle',
    'CONFIGURATION_ADMIN_GESTION_EMAIL': 'Configuration Admin > Gestion Email',
    'CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE': 'Configuration Admin > Gestion Email',
    'CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY': 'Configuration Admin > Gestion Email',
    'CONFIGURATION_ADMIN_GESTION_EMAIL_READ': 'Configuration Admin > Gestion Email',
    'CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE': 'Configuration Admin > Gestion Email',
    'CONFIGURATION_ADMIN_INFRASTRUCTURE': 'Configuration Admin > Infrastructure',
    'CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE': 'Configuration Admin > Infrastructure',
    'CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY': 'Configuration Admin > Infrastructure',
    'CONFIGURATION_ADMIN_INFRASTRUCTURE_READ': 'Configuration Admin > Infrastructure',
    'CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE': 'Configuration Admin > Infrastructure',
    'EXPLOITATION': 'Exploitation',
    'EXPLOITATION_CHAUFFEUR': 'Exploitation > Chauffeur',
    'EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR': 'Exploitation > Chauffeur > Absence',
    'EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_DELETE': 'Exploitation > Chauffeur > Absence',
    'EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_MODIFY': 'Exploitation > Chauffeur > Absence',
    'EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_READ': 'Exploitation > Chauffeur > Absence',
    'EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_WRITE': 'Exploitation > Chauffeur > Absence',
    'EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE': 'Exploitation > Chauffeur > Feuille de Route',
    'EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_DELETE': 'Exploitation > Chauffeur > Feuille de Route',
    'EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_MODIFY': 'Exploitation > Chauffeur > Feuille de Route',
    'EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_READ': 'Exploitation > Chauffeur > Feuille de Route',
    'EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_WRITE': 'Exploitation > Chauffeur > Feuille de Route',
    'EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR': 'Exploitation > Chauffeur > Liste Chauffeur',
    'EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_DELETE': 'Exploitation > Chauffeur > Liste Chauffeur',
    'EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_MODIFY': 'Exploitation > Chauffeur > Liste Chauffeur',
    'EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_READ': 'Exploitation > Chauffeur > Liste Chauffeur',
    'EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_WRITE': 'Exploitation > Chauffeur > Liste Chauffeur',
    'EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR': 'Exploitation > Chauffeur > Planning Chauffeur',
    'EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_DELETE': 'Exploitation > Chauffeur > Planning Chauffeur',
    'EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_MODIFY': 'Exploitation > Chauffeur > Planning Chauffeur',
    'EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_READ': 'Exploitation > Chauffeur > Planning Chauffeur',
    'EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_WRITE': 'Exploitation > Chauffeur > Planning Chauffeur',
    'EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET': 'Exploitation > Chauffeur > Suivi Trajet',
    'EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_DELETE': 'Exploitation > Chauffeur > Suivi Trajet',
    'EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_MODIFY': 'Exploitation > Chauffeur > Suivi Trajet',
    'EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_READ': 'Exploitation > Chauffeur > Suivi Trajet',
    'EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_WRITE': 'Exploitation > Chauffeur > Suivi Trajet',
    'EXPLOITATION_CIRCUIT_USAGER': 'Exploitation > Circuit Usager',
    'EXPLOITATION_CIRCUIT_USAGER_ABSENCE': 'Exploitation > Circuit Usager > Absence',
    'EXPLOITATION_CIRCUIT_USAGER_ABSENCE_DELETE': 'Exploitation > Circuit Usager > Absence',
    'EXPLOITATION_CIRCUIT_USAGER_ABSENCE_MODIFY': 'Exploitation > Circuit Usager > Absence',
    'EXPLOITATION_CIRCUIT_USAGER_ABSENCE_READ': 'Exploitation > Circuit Usager > Absence',
    'EXPLOITATION_CIRCUIT_USAGER_ABSENCE_WRITE': 'Exploitation > Circuit Usager > Absence',
    'EXPLOITATION_CIRCUIT_USAGER_AVENANT': 'Exploitation > Circuit Usager > Avenant',
    'EXPLOITATION_CIRCUIT_USAGER_AVENANT_DELETE': 'Exploitation > Circuit Usager > Avenant',
    'EXPLOITATION_CIRCUIT_USAGER_AVENANT_MODIFY': 'Exploitation > Circuit Usager > Avenant',
    'EXPLOITATION_CIRCUIT_USAGER_AVENANT_READ': 'Exploitation > Circuit Usager > Avenant',
    'EXPLOITATION_CIRCUIT_USAGER_AVENANT_WRITE': 'Exploitation > Circuit Usager > Avenant',
    'EXPLOITATION_CIRCUIT_USAGER_CIRCUIT': 'Exploitation > Circuit Usager > Circuit',
    'EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_DELETE': 'Exploitation > Circuit Usager > Circuit',
    'EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_MODIFY': 'Exploitation > Circuit Usager > Circuit',
    'EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_READ': 'Exploitation > Circuit Usager > Circuit',
    'EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_WRITE': 'Exploitation > Circuit Usager > Circuit',
    'EXPLOITATION_CIRCUIT_USAGER_TRAJET': 'Exploitation > Circuit Usager > Trajet',
    'EXPLOITATION_CIRCUIT_USAGER_TRAJET_DELETE': 'Exploitation > Circuit Usager > Trajet',
    'EXPLOITATION_CIRCUIT_USAGER_TRAJET_MODIFY': 'Exploitation > Circuit Usager > Trajet',
    'EXPLOITATION_CIRCUIT_USAGER_TRAJET_READ': 'Exploitation > Circuit Usager > Trajet',
    'EXPLOITATION_CIRCUIT_USAGER_TRAJET_WRITE': 'Exploitation > Circuit Usager > Trajet',
    'EXPLOITATION_CIRCUIT_USAGER_USAGER': 'Exploitation > Circuit Usager > Usager',
    'EXPLOITATION_CIRCUIT_USAGER_USAGER_DELETE': 'Exploitation > Circuit Usager > Usager',
    'EXPLOITATION_CIRCUIT_USAGER_USAGER_MODIFY': 'Exploitation > Circuit Usager > Usager',
    'EXPLOITATION_CIRCUIT_USAGER_USAGER_READ': 'Exploitation > Circuit Usager > Usager',
    'EXPLOITATION_CIRCUIT_USAGER_USAGER_WRITE': 'Exploitation > Circuit Usager > Usager',
    'EXPLOITATION_CLIENT': 'Exploitation > Client',
    'EXPLOITATION_CLIENT_DELETE': 'Exploitation > Client',
    'EXPLOITATION_CLIENT_MODIFY': 'Exploitation > Client',
    'EXPLOITATION_CLIENT_READ': 'Exploitation > Client',
    'EXPLOITATION_CLIENT_WRITE': 'Exploitation > Client',
    'EXPLOITATION_CONTRAT': 'Exploitation > Contrat',
    'EXPLOITATION_CONTRAT_DELETE': 'Exploitation > Contrat',
    'EXPLOITATION_CONTRAT_MODIFY': 'Exploitation > Contrat',
    'EXPLOITATION_CONTRAT_READ': 'Exploitation > Contrat',
    'EXPLOITATION_CONTRAT_WRITE': 'Exploitation > Contrat',
    'EXPLOITATION_ETABLISSEMENT': 'Exploitation > Etablissement',
    'EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE': 'Exploitation > Etablissement > Feuille de Présence',
    'EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_DELETE': 'Exploitation > Etablissement > Feuille de Présence',
    'EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_MODIFY': 'Exploitation > Etablissement > Feuille de Présence',
    'EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_READ': 'Exploitation > Etablissement > Feuille de Présence',
    'EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_WRITE': 'Exploitation > Etablissement > Feuille de Présence',
    'EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT': 'Exploitation > Etablissement > Liste Etablissement',
    'EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_DELETE': 'Exploitation > Etablissement > Liste Etablissement',
    'EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_MODIFY': 'Exploitation > Etablissement > Liste Etablissement',
    'EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_READ': 'Exploitation > Etablissement > Liste Etablissement',
    'EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_WRITE': 'Exploitation > Etablissement > Liste Etablissement',
    'EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE': 'Exploitation > Etablissement > Vacance/Jour Férié',
    'EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_DELETE': 'Exploitation > Etablissement > Vacance/Jour Férié',
    'EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_MODIFY': 'Exploitation > Etablissement > Vacance/Jour Férié',
    'EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_READ': 'Exploitation > Etablissement > Vacance/Jour Férié',
    'EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_WRITE': 'Exploitation > Etablissement > Vacance/Jour Férié',
    'EXPLOITATION_PREPARATION': 'Exploitation > Préparation',
    'EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR': 'Exploitation > Préparation > Préparation Chauffeur',
    'EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_DELETE': 'Exploitation > Préparation > Préparation Chauffeur',
    'EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_MODIFY': 'Exploitation > Préparation > Préparation Chauffeur',
    'EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_READ': 'Exploitation > Préparation > Préparation Chauffeur',
    'EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_WRITE': 'Exploitation > Préparation > Préparation Chauffeur',
    'EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT': 'Exploitation > Préparation > Préparation Circuit',
    'EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_DELETE': 'Exploitation > Préparation > Préparation Circuit',
    'EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_MODIFY': 'Exploitation > Préparation > Préparation Circuit',
    'EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_READ': 'Exploitation > Préparation > Préparation Circuit',
    'EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_WRITE': 'Exploitation > Préparation > Préparation Circuit',
    'EXPLOITATION_PREPARATION_PREPARATION_USAGER': 'Exploitation > Préparation > Préparation Usager',
    'EXPLOITATION_PREPARATION_PREPARATION_USAGER_DELETE': 'Exploitation > Préparation > Préparation Usager',
    'EXPLOITATION_PREPARATION_PREPARATION_USAGER_MODIFY': 'Exploitation > Préparation > Préparation Usager',
    'EXPLOITATION_PREPARATION_PREPARATION_USAGER_READ': 'Exploitation > Préparation > Préparation Usager',
    'EXPLOITATION_PREPARATION_PREPARATION_USAGER_WRITE': 'Exploitation > Préparation > Préparation Usager',
    'FACTURATION_PAIEMENT': 'Facturation et Paiement',
    'FACTURATION_PAIEMENT_DELETE': 'Facturation et Paiement',
    'FACTURATION_PAIEMENT_MODIFY': 'Facturation et Paiement',
    'FACTURATION_PAIEMENT_READ': 'Facturation et Paiement',
    'FACTURATION_PAIEMENT_WRITE': 'Facturation et Paiement',
    'FLOTTES': 'Flottes',
    'FLOTTES_CARBURANT_CONSOMMATION': 'Flottes > Carburant et Consommation',
    'FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE': 'Flottes > Carburant et Consommation > Anomalie Traitée',
    'FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_DELETE': 'Flottes > Carburant et Consommation > Anomalie Traitée',
    'FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_MODIFY': 'Flottes > Carburant et Consommation > Anomalie Traitée',
    'FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_READ': 'Flottes > Carburant et Consommation > Anomalie Traitée',
    'FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_WRITE': 'Flottes > Carburant et Consommation > Anomalie Traitée',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT': 'Flottes > Carburant et Consommation > Suivi Carburant',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_DELETE': 'Flottes > Carburant et Consommation > Suivi Carburant',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_MODIFY': 'Flottes > Carburant et Consommation > Suivi Carburant',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_READ': 'Flottes > Carburant et Consommation > Suivi Carburant',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_WRITE': 'Flottes > Carburant et Consommation > Suivi Carburant',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE': 'Flottes > Carburant et Consommation > Suivi Kilométrage',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_DELETE': 'Flottes > Carburant et Consommation > Suivi Kilométrage',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_MODIFY': 'Flottes > Carburant et Consommation > Suivi Kilométrage',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_READ': 'Flottes > Carburant et Consommation > Suivi Kilométrage',
    'FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_WRITE': 'Flottes > Carburant et Consommation > Suivi Kilométrage',
    'FLOTTES_ENTRETIEN': 'Flottes > Entretien',
    'FLOTTES_ENTRETIEN_DELETE': 'Flottes > Entretien',
    'FLOTTES_ENTRETIEN_MODIFY': 'Flottes > Entretien',
    'FLOTTES_ENTRETIEN_READ': 'Flottes > Entretien',
    'FLOTTES_ENTRETIEN_WRITE': 'Flottes > Entretien',
    'FLOTTES_INCIDENTS': 'Flottes > Incidents',
    'FLOTTES_INCIDENTS_DELETE': 'Flottes > Incidents',
    'FLOTTES_INCIDENTS_MODIFY': 'Flottes > Incidents',
    'FLOTTES_INCIDENTS_READ': 'Flottes > Incidents',
    'FLOTTES_INCIDENTS_WRITE': 'Flottes > Incidents',
    'FLOTTES_VEHICULE': 'Flottes > Véhicule',
    'FLOTTES_VEHICULE_DELETE': 'Flottes > Véhicule',
    'FLOTTES_VEHICULE_MODIFY': 'Flottes > Véhicule',
    'FLOTTES_VEHICULE_READ': 'Flottes > Véhicule',
    'FLOTTES_VEHICULE_WRITE': 'Flottes > Véhicule',
    'GEOLOCALISATION': 'Géolocalisation',
    'GEOLOCALISATION_DELETE': 'Géolocalisation',
    'GEOLOCALISATION_MODIFY': 'Géolocalisation',
    'GEOLOCALISATION_READ': 'Géolocalisation',
    'GEOLOCALISATION_WRITE': 'Géolocalisation',
    'PLANNING': 'Planning',
    'PLANNING_PLANNING_CHAUFFEUR': 'Planning > Planning Chauffeur',
    'PLANNING_PLANNING_CHAUFFEUR_DELETE': 'Planning > Planning Chauffeur',
    'PLANNING_PLANNING_CHAUFFEUR_MODIFY': 'Planning > Planning Chauffeur',
    'PLANNING_PLANNING_CHAUFFEUR_READ': 'Planning > Planning Chauffeur',
    'PLANNING_PLANNING_CHAUFFEUR_WRITE': 'Planning > Planning Chauffeur',
    'PLANNING_PLANNING_LOCATION': 'Planning > Planning Location',
    'PLANNING_PLANNING_LOCATION_DELETE': 'Planning > Planning Location',
    'PLANNING_PLANNING_LOCATION_MODIFY': 'Planning > Planning Location',
    'PLANNING_PLANNING_LOCATION_READ': 'Planning > Planning Location',
    'PLANNING_PLANNING_LOCATION_WRITE': 'Planning > Planning Location',
    'PLANNING_PLANNING_VEHICULE': 'Planning > Planning Véhicule',
    'PLANNING_PLANNING_VEHICULE_DELETE': 'Planning > Planning Véhicule',
    'PLANNING_PLANNING_VEHICULE_MODIFY': 'Planning > Planning Véhicule',
    'PLANNING_PLANNING_VEHICULE_READ': 'Planning > Planning Véhicule',
    'PLANNING_PLANNING_VEHICULE_WRITE': 'Planning > Planning Véhicule',
    'RH': 'RH',
    'RH_DOCUMENT': 'RH > Document',
    'RH_DOCUMENT_DELETE': 'RH > Document',
    'RH_DOCUMENT_MODIFY': 'RH > Document',
    'RH_DOCUMENT_READ': 'RH > Document',
    'RH_DOCUMENT_WRITE': 'RH > Document',
    'RH_GESTION_ABSENCE': 'RH > Gestion Absence',
    'RH_GESTION_ABSENCE_DELETE': 'RH > Gestion Absence',
    'RH_GESTION_ABSENCE_MODIFY': 'RH > Gestion Absence',
    'RH_GESTION_ABSENCE_READ': 'RH > Gestion Absence',
    'RH_GESTION_ABSENCE_WRITE': 'RH > Gestion Absence',
    'RH_GESTION_DE_CALENDRIER': 'RH > Gestion de Calendrier',
    'RH_GESTION_DE_CALENDRIER_DELETE': 'RH > Gestion de Calendrier',
    'RH_GESTION_DE_CALENDRIER_MODIFY': 'RH > Gestion de Calendrier',
    'RH_GESTION_DE_CALENDRIER_READ': 'RH > Gestion de Calendrier',
    'RH_GESTION_DE_CALENDRIER_WRITE': 'RH > Gestion de Calendrier',
    'RH_GESTION_DE_CONGE': 'RH > Gestion de Congé',
    'RH_GESTION_DE_CONGE_DELETE': 'RH > Gestion de Congé',
    'RH_GESTION_DE_CONGE_MODIFY': 'RH > Gestion de Congé',
    'RH_GESTION_DE_CONGE_READ': 'RH > Gestion de Congé',
    'RH_GESTION_DE_CONGE_WRITE': 'RH > Gestion de Congé',
    'RH_GESTION_DE_SALARIES': 'RH > Gestion de Salariés',
    'RH_GESTION_DE_SALARIES_DELETE': 'RH > Gestion de Salariés',
    'RH_GESTION_DE_SALARIES_MODIFY': 'RH > Gestion de Salariés',
    'RH_GESTION_DE_SALARIES_READ': 'RH > Gestion de Salariés',
    'RH_GESTION_DE_SALARIES_WRITE': 'RH > Gestion de Salariés',
    'RH_GESTION_RECRUTEMENT': 'RH > Gestion Recrutement',
    'RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT': 'RH > Gestion Recrutement > Besoins Recrutement',
    'RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_DELETE': 'RH > Gestion Recrutement > Besoins Recrutement',
    'RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_MODIFY': 'RH > Gestion Recrutement > Besoins Recrutement',
    'RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_READ': 'RH > Gestion Recrutement > Besoins Recrutement',
    'RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_WRITE': 'RH > Gestion Recrutement > Besoins Recrutement',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR': 'RH > Gestion Recrutement > Candidature Chauffeur',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_DELETE': 'RH > Gestion Recrutement > Candidature Chauffeur',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_MODIFY': 'RH > Gestion Recrutement > Candidature Chauffeur',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_READ': 'RH > Gestion Recrutement > Candidature Chauffeur',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_WRITE': 'RH > Gestion Recrutement > Candidature Chauffeur',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE': 'RH > Gestion Recrutement > Candidature Sédentaire',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_DELETE': 'RH > Gestion Recrutement > Candidature Sédentaire',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_MODIFY': 'RH > Gestion Recrutement > Candidature Sédentaire',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_READ': 'RH > Gestion Recrutement > Candidature Sédentaire',
    'RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_WRITE': 'RH > Gestion Recrutement > Candidature Sédentaire',
    'RH_RDV_ANNUEL': 'RH > RDV Annuel',
    'RH_RDV_ANNUEL_DELETE': 'RH > RDV Annuel',
    'RH_RDV_ANNUEL_MODIFY': 'RH > RDV Annuel',
    'RH_RDV_ANNUEL_READ': 'RH > RDV Annuel',
    'RH_RDV_ANNUEL_WRITE': 'RH > RDV Annuel',
    'STAFF': 'Staff',
    'STAFF_GESTION_DOCUMENTS': 'Staff > Gestion Documents',
    'STAFF_GESTION_DOCUMENTS_DELETE': 'Staff > Gestion Documents',
    'STAFF_GESTION_DOCUMENTS_MODIFY': 'Staff > Gestion Documents',
    'STAFF_GESTION_DOCUMENTS_READ': 'Staff > Gestion Documents',
    'STAFF_GESTION_DOCUMENTS_WRITE': 'Staff > Gestion Documents',
};
  
  export const PermissionImplications: Record<Permission, Permission[]> = {
    [Permission.APPEL_OFFRE]: [],
    [Permission.APPEL_OFFRE_DELETE]: [],
    [Permission.APPEL_OFFRE_MODIFY]: [],
    [Permission.APPEL_OFFRE_READ]: [],
    [Permission.APPEL_OFFRE_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ]: [],
    [Permission.CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_READ]: [],
    [Permission.CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_READ]: [],
    [Permission.CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE]: [],
    [Permission.EXPLOITATION]: [],
    [Permission.EXPLOITATION_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_DELETE]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_MODIFY]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_READ]: [],
    [Permission.EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_ABSENCE_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_AVENANT_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_TRAJET_WRITE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_DELETE]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_MODIFY]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_READ]: [],
    [Permission.EXPLOITATION_CIRCUIT_USAGER_USAGER_WRITE]: [],
    [Permission.EXPLOITATION_CLIENT]: [],
    [Permission.EXPLOITATION_CLIENT_DELETE]: [],
    [Permission.EXPLOITATION_CLIENT_MODIFY]: [],
    [Permission.EXPLOITATION_CLIENT_READ]: [],
    [Permission.EXPLOITATION_CLIENT_WRITE]: [],
    [Permission.EXPLOITATION_CONTRAT]: [],
    [Permission.EXPLOITATION_CONTRAT_DELETE]: [],
    [Permission.EXPLOITATION_CONTRAT_MODIFY]: [],
    [Permission.EXPLOITATION_CONTRAT_READ]: [],
    [Permission.EXPLOITATION_CONTRAT_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_WRITE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_DELETE]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_MODIFY]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_READ]: [],
    [Permission.EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_WRITE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_DELETE]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_MODIFY]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_READ]: [],
    [Permission.EXPLOITATION_PREPARATION_PREPARATION_USAGER_WRITE]: [],
    [Permission.FACTURATION_PAIEMENT]: [],
    [Permission.FACTURATION_PAIEMENT_DELETE]: [],
    [Permission.FACTURATION_PAIEMENT_MODIFY]: [],
    [Permission.FACTURATION_PAIEMENT_READ]: [],
    [Permission.FACTURATION_PAIEMENT_WRITE]: [],
    [Permission.FLOTTES]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_WRITE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_WRITE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_DELETE]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_MODIFY]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_READ]: [],
    [Permission.FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_WRITE]: [],
    [Permission.FLOTTES_ENTRETIEN]: [],
    [Permission.FLOTTES_ENTRETIEN_DELETE]: [],
    [Permission.FLOTTES_ENTRETIEN_MODIFY]: [],
    [Permission.FLOTTES_ENTRETIEN_READ]: [],
    [Permission.FLOTTES_ENTRETIEN_WRITE]: [],
    [Permission.FLOTTES_INCIDENTS]: [],
    [Permission.FLOTTES_INCIDENTS_DELETE]: [],
    [Permission.FLOTTES_INCIDENTS_MODIFY]: [],
    [Permission.FLOTTES_INCIDENTS_READ]: [],
    [Permission.FLOTTES_INCIDENTS_WRITE]: [],
    [Permission.FLOTTES_VEHICULE]: [],
    [Permission.FLOTTES_VEHICULE_DELETE]: [],
    [Permission.FLOTTES_VEHICULE_MODIFY]: [],
    [Permission.FLOTTES_VEHICULE_READ]: [],
    [Permission.FLOTTES_VEHICULE_WRITE]: [],
    [Permission.GEOLOCALISATION]: [],
    [Permission.GEOLOCALISATION_DELETE]: [],
    [Permission.GEOLOCALISATION_MODIFY]: [],
    [Permission.GEOLOCALISATION_READ]: [],
    [Permission.GEOLOCALISATION_WRITE]: [],
    [Permission.PLANNING]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_DELETE]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_MODIFY]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_READ]: [],
    [Permission.PLANNING_PLANNING_CHAUFFEUR_WRITE]: [],
    [Permission.PLANNING_PLANNING_LOCATION]: [],
    [Permission.PLANNING_PLANNING_LOCATION_DELETE]: [],
    [Permission.PLANNING_PLANNING_LOCATION_MODIFY]: [],
    [Permission.PLANNING_PLANNING_LOCATION_READ]: [],
    [Permission.PLANNING_PLANNING_LOCATION_WRITE]: [],
    [Permission.PLANNING_PLANNING_VEHICULE]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_DELETE]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_MODIFY]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_READ]: [],
    [Permission.PLANNING_PLANNING_VEHICULE_WRITE]: [],
    [Permission.RH]: [],
    [Permission.RH_DOCUMENT]: [],
    [Permission.RH_DOCUMENT_DELETE]: [],
    [Permission.RH_DOCUMENT_MODIFY]: [],
    [Permission.RH_DOCUMENT_READ]: [],
    [Permission.RH_DOCUMENT_WRITE]: [],
    [Permission.RH_GESTION_ABSENCE]: [],
    [Permission.RH_GESTION_ABSENCE_DELETE]: [],
    [Permission.RH_GESTION_ABSENCE_MODIFY]: [],
    [Permission.RH_GESTION_ABSENCE_READ]: [],
    [Permission.RH_GESTION_ABSENCE_WRITE]: [],
    [Permission.RH_GESTION_DE_CALENDRIER]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_DELETE]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_MODIFY]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_READ]: [],
    [Permission.RH_GESTION_DE_CALENDRIER_WRITE]: [],
    [Permission.RH_GESTION_DE_CONGE]: [],
    [Permission.RH_GESTION_DE_CONGE_DELETE]: [],
    [Permission.RH_GESTION_DE_CONGE_MODIFY]: [],
    [Permission.RH_GESTION_DE_CONGE_READ]: [],
    [Permission.RH_GESTION_DE_CONGE_WRITE]: [],
    [Permission.RH_GESTION_DE_SALARIES]: [],
    [Permission.RH_GESTION_DE_SALARIES_DELETE]: [],
    [Permission.RH_GESTION_DE_SALARIES_MODIFY]: [],
    [Permission.RH_GESTION_DE_SALARIES_READ]: [],
    [Permission.RH_GESTION_DE_SALARIES_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_WRITE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_DELETE]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_MODIFY]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_READ]: [],
    [Permission.RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_WRITE]: [],
    [Permission.RH_RDV_ANNUEL]: [],
    [Permission.RH_RDV_ANNUEL_DELETE]: [],
    [Permission.RH_RDV_ANNUEL_MODIFY]: [],
    [Permission.RH_RDV_ANNUEL_READ]: [],
    [Permission.RH_RDV_ANNUEL_WRITE]: [],
    [Permission.STAFF]: [],
    [Permission.STAFF_GESTION_DOCUMENTS]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_DELETE]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_MODIFY]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_READ]: [],
    [Permission.STAFF_GESTION_DOCUMENTS_WRITE]: [],
  };
  
  /** Checks if a string is a known Permission. */
  export function hasPermission(p: string): p is Permission {
    return Object.values(Permission).includes(p as Permission);
  }
  
  /** Throws if the string is not a known Permission. */
  export function validatePermission(p: string): asserts p is Permission {
    if (!hasPermission(p)) {
      throw new Error(`Invalid permission: ${p}`);
    }
  }
  
  /** Recursively collects all derived permissions. */
  export function getAllDerivedPermissions(perms: Permission[]): Permission[] {
    const result = new Set<Permission>();
    function traverse(p: Permission) {
      if (result.has(p)) return;
      result.add(p);
      (PermissionHierarchy[p] || []).forEach(traverse);
      (PermissionImplications[p] || []).forEach(traverse);
    }
    perms.forEach(traverse);
    return Array.from(result);
  }

  export function translatePermissionAction(action: string): string {
    return PERMISSION_TRANSLATIONS[action] || action;
  }


  export function processPermissions(permissions: Permission[]) {
    const modulesMap: Record<string, { module: string, permissions: string[], date: string }> = {};
  
    permissions.forEach((permission) => {
      const parts = permission.split('_');
      const moduleName = MODULE_TO_BASE[permission] || 'Unknown Module';
      
      const action = parts[parts.length - 1];
      const translatedAction = translatePermissionAction(action);
      
      if (!modulesMap[moduleName]) {
        modulesMap[moduleName] = {
          module: moduleName,
          permissions: [],
          date: new Date().toISOString(),
        };
      }
      
      modulesMap[moduleName].permissions.push(translatedAction);
    });
  
    return Object.values(modulesMap);
  }
  