import IconButton from '@mui/material/IconButton';
import { faFileExport, faMapMarkedAlt, faTable } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import { useRouter } from 'next/navigation';
import { paths } from '@/routes/paths';

// ----------------------------------------------------------------------

export default function ExportNavigation() {
  const router = useRouter();

  const handleClick = () => {
    router.push(paths.dashboard.export.root);
  };
  return (
    <CustomTooltip title="Exports de fichiers" arrow>
      <IconButton sx={WhiteIconButtonStyle} onClick={handleClick}>
        <FontAwesome icon={faFileExport} />
      </IconButton>
    </CustomTooltip>
  );
}
