import { useTheme } from '@mui/material/styles';
import IconButton, { IconButtonProps } from '@mui/material/IconButton';
import { bgBlur } from '@/shared/theme/css';
import { useNavBar } from '@/contexts/settings/nav-bar-context';
import { faAngleLeft, faAngleRight } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';

// ----------------------------------------------------------------------


interface NavToggleButtonProps extends IconButtonProps {
  onClose?: () => void
}

export default function NavToggleButton({ sx, onClose, ...other }: NavToggleButtonProps) {
  const theme = useTheme()
  const { isNavBarMinimized, toggleNavBar } = useNavBar()

  const handleClick = () => {
    if (onClose) {
      onClose()
    } else {
      toggleNavBar()
    }
  }

  return (
    <IconButton
      size="small"
      onClick={handleClick}
      sx={{
        p: 0.5,
        top: 28,
        position: 'fixed',  
        zIndex: theme.zIndex.appBar + 1,
        border: `dashed 1px ${theme.palette.divider}`,
        ...bgBlur({ color: theme.palette.background.default }),
        '&:hover': {
          bgcolor: 'background.default',
        },
        ...sx,
      }}
      {...other}
    >
      <FontAwesome
        icon={onClose ? faAngleRight : isNavBarMinimized ? faAngleRight : faAngleLeft}
        color={theme.palette.primary.main}
        width={16}
      />
    </IconButton>
  );
}
