import { type IAbsence, EtatDemandeRecue, EtatDemandeTraitee } from "../types/absence"
import { Sens } from "../types/circuit"
import { TableColumn } from "../types/common"
import { _SENS_AR } from "."
import { _OPTION_DEMANDE } from "../sections/absence/utils/form-fields-absence"

export const _ETABLISSEMENTS = ["Bellevue", "Soleil", "Saint-Joseph", "Marie-Curie"]

export const _USERS = ["Anna Leblanc", "Thomas Dubois", "Marie Martin", "Lucas Bernard"]



const TOTAL_ABSENCES = 30
const START_DATE = new Date(2024, 0, 15).toISOString().split("T")[0]
const END_DATE = START_DATE
const RECEPTION_MODES = ["Portail", "Application mobile"]
const COMMENT_TYPES = ["SMS", "E-mail", "Appel tel"]

const generateAbsences = (etats: any[]) => {
  const absences = []
  for (let i = 0; i < TOTAL_ABSENCES; i++) {
    absences.push({
      id: (i + 1).toString(),
      usager: _USERS[i % _USERS.length],
      etat: etats[i % etats.length],
      etablissement: _ETABLISSEMENTS[i % _ETABLISSEMENTS.length],
      dateDebut: START_DATE,
      dateFin: END_DATE,
      sensAR: i % 2 === 0 ? Sens.Aller : Sens.Retour,
      observation:
        i % 2 === 0
          ? "Justifiant son absence par une maladie nécessitant du repos."
          : 'Motif ou préciser "motif non communiqué"',
      modeReception: RECEPTION_MODES[i % 2],
      previentLe: "2025-01-15",
      departement: "Val-de-Marne",
      comment: COMMENT_TYPES[i % 3],
      par: "Sophie Rose",
    })
  }
  return absences
}

const etatsTraites = [EtatDemandeTraitee.Traite, EtatDemandeTraitee.Annule, EtatDemandeTraitee.Averti]
const etatsRecus = [EtatDemandeRecue.EnCours, EtatDemandeRecue.NonTraite]

export const _absencesTraitees = generateAbsences(etatsTraites)
export const _absencesRecues = generateAbsences(etatsRecus)
 export const getAbsenceEtat = (status: string): string => {
    const statusObj = _OPTION_DEMANDE.find(s => s.value === status);
    return statusObj ? statusObj.label : "Inconnu";
  };
  export const getSensLabel = (sens: string): string => {
    const sensObj = _SENS_AR.find(s => s.value === sens);
    return sensObj ? sensObj.label : "Inconnu";
  };
export const DEFAULT_ABSENCE_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° d'enregistrement", type: "text", align: "center" },
  { id: "usager", label: "Usager", type: "text", align: "left" },
  { id: "etat", label: "État", type: "status", align: "left" },
  { id: "etablissement", label: "Établissement", type: "text", align: "left" },
  { id: "dateDebut", label: "Du", type: "date", align: "center" },
  { id: "dateFin", label: "Au", type: "date", align: "center" },
  { id: "sensAR", label: "Trajets concernés", type: "status", align: "left" },
  { id: "observation", label: "Observations", type: "text", align: "left" },
  { id: "modeReception", label: "Mode de réception", type: "text", align: "left" },
  { id: "previentLe", label: "Prévient le", type: "date", align: "center" },
  { id: "departement", label: "Département", type: "text", align: "left" },
  { id: "comment", label: "Comment", type: "text", align: "left" },
  { id: "par", label: "Par", type: "text", align: "left" },
  { id: '', label: 'Action' },
]

export const INITIAL_ABSENCE_DATA: IAbsence = {
  id: "",
  usager: {
    id: 1,
    firstName: "",
    lastName: "",
    establishmentName: "",
    departmentName: ""
  },
  etat: [EtatDemandeRecue.NonTraite],
  etablissement: "",
  dateDebut: "",
  dateFin: "",
  sensAR: [Sens.Aller],
  observation: "",
  modeReception: "",
  previentLe: "",
  departement: "",
  comment: "SMS",
  par: "",
}
