import { TableColumn } from "../types/common";
import { Candidat, CandidatStatus } from "../types/candidat";
import { FUEL_CARDS, INITIAL_ADDRESS, MOCK_ADDRESSES } from ".";

const generateRandomPhone = () => {
  return `0${Math.floor(Math.random() * 5) + 5}${Array(8).fill(0).map(() => Math.floor(Math.random() * 10)).join('')}`;
};

const generateRandomAddress = () => {
  const streetNumber = Math.floor(Math.random() * 100) + 1;
  const streets = ['rue de la Paix', 'avenue Victor Hugo', 'boulevard Saint-Michel', 'rue du Commerce', 'avenue des Champs-Élysées'];
  const cities = ['Paris', 'Lyon', 'Marseille', 'Toulouse', 'Nantes'];
  const postalCodes = ['75000', '69000', '13000', '31000', '44000'];

  const streetIndex = Math.floor(Math.random() * streets.length);
  return {
    rue: `${streetNumber} ${streets[streetIndex]}`,
    ville: cities[streetIndex],
    codePostal: postalCodes[streetIndex]
  };
};

export const _candidats: Candidat[] = [...Array(50)].map((_, index) => {
  const address = generateRandomAddress();

  return {
    id: (index + 1).toString(),
    numeroSalarié: `S${(index + 1).toString().padStart(6, '0')}`,
    civilite: ['M', 'Mme', 'Mlle'][Math.floor(Math.random() * 3)] as 'M' | 'Mme' | 'Mlle',
    nom: ['Martin', 'Bernard', 'Dubois', 'Thomas', 'Robert', 'Petit', 'Richard', 'Garcia', 'David', 'Bertrand'][Math.floor(Math.random() * 10)],
    nomFamille: ['Dupont', 'Durant', 'Leroy', 'Moreau', 'Simon', 'Laurent', 'Michel', 'Lefebvre', 'Lefevre', 'Mercier'][Math.floor(Math.random() * 10)],
    prenom: ['Emma', 'Lucas', 'Léa', 'Hugo', 'Chloé', 'Louis', 'Jules', 'Arthur', 'Louise', 'Alice'][Math.floor(Math.random() * 10)],
    villeNaissance: ['Paris', 'Lyon', 'Marseille', 'Toulouse', 'Nantes'][Math.floor(Math.random() * 5)],
    dateNaissance: new Date(1980 + Math.floor(Math.random() * 20), Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1).toISOString().split('T')[0],
    nationalite: ['Française', 'Belge', 'Suisse', 'Canadienne'][Math.floor(Math.random() * 4)],
    telephone: generateRandomPhone(),
    email: `candidat${index + 1}@example.com`,
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    fuelCard: [FUEL_CARDS[index % FUEL_CARDS.length]],
    ville: address.ville,
    codePostal: address.codePostal,
    dureePermis: `${Math.floor(Math.random() * 10) + 1} ans`,
    numeroPermis: `P${Math.random().toString(36).substring(2, 8).toUpperCase()}`,
    numeroSS: `${Math.floor(Math.random() * 3) + 1}${Array(13).fill(0).map(() => Math.floor(Math.random() * 10)).join('')}`,
    dateDebutContrat: new Date(2024, Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1).toISOString().split('T')[0],
    dateSignatureContrat: new Date(2024, Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1).toISOString().split('T')[0],
    dateInscription: new Date(2023, Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1).toISOString().split('T')[0],
    status: ['Salarié', 'Sorti', 'Archivé'][Math.floor(Math.random() * 3)] as CandidatStatus,
    tauxHoraire: Math.floor(Math.random() * 10) + 15,
    cni: null,
    permisConduire: null,
    carteVitale: null,
    rib: null,
    type: Math.random() < 0.5 ? 'chauffeur' : 'sedentaire',
    departement: 'Maintenance',
  };
});

export const DEFAULT_CANDIDAT_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroSalarié', label: 'N° Salarié', type: 'text', align: 'left' },
  { id: 'civilite', label: 'Civilité', type: 'text', align: 'left' },
  { id: 'nom', label: 'Nom', type: 'text', align: 'left' },
  { id: 'prenom', label: 'Prénom', type: 'text', align: 'left' },
  { id: 'telephone', label: 'Téléphone', type: 'text', align: 'left' },
  { id: 'email', label: 'Email', type: 'text', align: 'left' },
  { id: 'dateInscription', label: "Date d'inscription", type: 'date', align: 'center' },
  { id: 'status', label: 'Statut', type: 'text', align: 'center' },
  { id: 'departement', label: 'Département', type: 'text', align: 'center' },
  { id: 'type', label: 'Type', type: 'text', align: 'center' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' }
];

export const INITIAL_CANDIDAT_DATA: Candidat = {
  id: '',
  numeroSalarié: '',
  civilite: 'M',
  nom: '',
  nomFamille: '',
  prenom: '',
  villeNaissance: '',
  dateNaissance: '',
  nationalite: '',
  email: '',
  telephone: '',
  adresse: INITIAL_ADDRESS,
  codePostal: '',
  ville: '',
  dureePermis: '',
  numeroPermis: '',
  numeroSS: '',
  dateDebutContrat: '',
  dateSignatureContrat: '',
  dateInscription: '',
  fuelCard: [],
  status: 'Salarié',
  tauxHoraire: 0,
  cni: null,
  permisConduire: null,
  carteVitale: null,
  rib: null,
  type: 'chauffeur',
  workingHours: [
    { day: 0, startHour: 9, endHour: 17 }, 
    { day: 1, startHour: 9, endHour: 17 },
    { day: 2, startHour: 9, endHour: 17 },
    { day: 3, startHour: 9, endHour: 17 },
    { day: 4, startHour: 9, endHour: 17 },
  ],
  departement: '',
}; 