import type { TableColumn } from "../types/common"
import { Departements, EstablishmentType, type IEtablissement, type IResponsableEtablissement, RegimeType } from "../types/etablissement"
import { Civility } from "../types/usager"
import { ZoneType } from "../types/vacance"
import { _noms, _prenoms, ETS_NAMES, MOCK_ADDRESSES } from "."

export const _TYPE_OPTIONS = [
  { value: EstablishmentType.lycee, label: "Lycée" },
  { value: EstablishmentType.college, label: "Collège" },
  { value: EstablishmentType.primaire, label: "Primaire" },
]

export const _REGIME_OPTIONS = [
  { value: RegimeType.prive, label: "Privé" },
  { value: RegimeType.public, label: "Public" },
]


export const INITIAL_REPRESENTATIVE_DATA: IResponsableEtablissement = {
  id: "",
  civilite: Civility.M,
  firstName: "",
  lastName: "",
  telephone: "",
  email: "",
}

export const _etablissements: IEtablissement[] = [...Array(25)].map((_, index) => {
  const isEvenIndex = index % 2 === 0
  const lastName = _noms[index % 4]
  const departementsArray = Object.values(Departements);
  const mockAddress = MOCK_ADDRESSES[index % 4];

  const etablissement: IEtablissement = {
    id: (index + 1).toString(),
    nomEtablissement:ETS_NAMES[index % 3],
    adresse: mockAddress,
    regime: isEvenIndex ? RegimeType.prive : RegimeType.public,
    type: Object.values(EstablishmentType)[index % 3],
    codeUAI: `560691234A.${(index + 10).toString()}A`,
    horaire: `${((index % 12) + 8).toString().padStart(2, "0")}:10A`,
    telephone: "+33 4 78 56 12 34",
    zone: Object.values(ZoneType)[index % 3],
    isActive: Math.random() > 0.2,
    department: departementsArray[index % departementsArray.length],
    responsable: isEvenIndex
      ? {
          id: `resp_${index + 1}`,
          civilite: isEvenIndex ? Civility.M : Civility.MME,
          firstName: _prenoms[index % 4],
          lastName: lastName,
          telephone: "+33 1 23 45 67 89",
          email: `responsable10${lastName}@email.com`,
        }
      : {
          ...INITIAL_REPRESENTATIVE_DATA,
          id: `resp_${index + 1}`,
        },
    colorCode: "",
    telephoneFax: "",
    email: "",
    password: "",
    siteWeb: "",
    observation: "",
    idDO: "",
    codeDO: ""
  }

  return etablissement
})

export const DEFAULT_ETABLISSEMENT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° établissement", type: "text" },
  { id: "nomEtablissement", label: "Nom établissement", type: "text" },
  { id: "adresse", label: "Adresse", type: "text" },
  { id: "regime", label: "Regime", type: "status" },
  { id: "codeUAI", label: "Code UAI", type: "text" },
  { id: "horaire", label: "Horaire", type: "text",align:'center' },
  { id: "telephone", label: "Téléphone", type: "text" },
  { id: "type", label: "Type", type: "text"},
  { id: 'department', label: 'Département', type: 'text', align: 'center' },
  { id: "", label: "Action" },
]

export const INITIAL_ETABLISSEMENT_DATA: IEtablissement = {
  id: "",
  nomEtablissement: "",
  type: "",
  adresse: {
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
  },  
  regime: RegimeType.public,
  codeUAI: "",
  horaire: "",
  telephone: "",
  department: Departements.Cher,
  zone: ZoneType.A,
  isActive: true,
  responsable: INITIAL_REPRESENTATIVE_DATA,
  colorCode: "",
  telephoneFax: "",
  email: "",
  password: "",
  siteWeb: "",
  observation: "",
  idDO: "",
  codeDO: ""
}