// First, define the types
export type InterventionType = 'preventive' | 'corrective';
export type InterventionStatus = 'planned' | 'in_progress' | 'completed';

export interface Vehicle {
  immatriculation: string;
  modele: string;
  marque: string;
  chauffeur: string;
}

export interface PlanningEvent {
  id: string;
  title: string;
  type: InterventionType;
  vehicle: Vehicle;
  status: InterventionStatus;
  start: string;
  end: string;
  estimatedDuration?: number;
  interventionDetails: string;
  technician: string;
}

// Define color scheme
export const EVENT_COLORS = {
  preventive: {
    planned: '#4CAF50',      // Solid green
    in_progress: '#2196F3',  // Solid blue
    completed: '#757575'     // Solid grey
  },
  corrective: {
    planned: '#FF9800',      // Solid orange
    in_progress: '#F44336',  // Solid red
    completed: '#757575'     // Solid grey
  }
} as const;

// Helper function
const getDate = (daysFromToday: number, hours: number, minutes: number = 0) => {
  const date = new Date();
  date.setDate(date.getDate() + daysFromToday);
  date.setHours(hours, minutes, 0, 0);
  return date.toISOString();
};

// Mock data
export const _planningEvents: PlanningEvent[] = [
  {
    id: '1',
    title: 'Entretien préventif',
    type: 'preventive',
    vehicle: {
      immatriculation: 'AA-123-BB',
      modele: 'Sprinter',
      marque: 'Mercedes',
      chauffeur: 'Thomas Martin'
    },
    status: 'planned',
    start: getDate(0, 9),
    end: getDate(0, 11),
    estimatedDuration: 2,
    interventionDetails: 'Vidange',
    technician: 'John Doe'
  },
  {
    id: '2',
    title: 'Contrôle technique',
    type: 'preventive',
    vehicle: {
      immatriculation: 'BB-456-CC',
      modele: 'Transit',
      marque: 'Ford',
      chauffeur: 'Lucas Bernard'
    },
    status: 'in_progress',
    start: getDate(0, 14),
    end: getDate(0, 17),
    estimatedDuration: 3,
    interventionDetails: 'Contrôle technique',
    technician: 'John Doe'
  },
  {
    id: '3',
    title: 'Maintenance corrective',
    type: 'corrective',
    vehicle: {
      immatriculation: 'CC-789-DD',
      modele: 'Master',
      marque: 'Renault',
      chauffeur: 'Hugo Dubois'
    },
    status: 'completed',
    start: getDate(1, 10),
    end: getDate(1, 12),
    estimatedDuration: 2,
    interventionDetails: 'Réparation freins',
    technician: 'John Doe'
  },
  {
    id: '4',
    title: 'Réparation Climatisation',
    type: 'corrective',
    vehicle: {
      immatriculation: 'DD-012-EE',
      modele: 'Ducato',
      marque: 'Fiat',
      chauffeur: 'Jules Moreau'
    },
    status: 'planned',
    start: getDate(2, 9, 30), // In 2 days at 9:30
    end: getDate(2, 11, 30), // In 2 days at 11:30
    estimatedDuration: 2,
    interventionDetails: 'Recharge climatisation',
    technician: 'John Doe'
  },
  {
    id: '5',
    title: 'Révision',
    type: 'preventive',
    vehicle: {
      immatriculation: 'EE-345-FF',
      modele: 'Sprinter',
      marque: 'Mercedes',
      chauffeur: 'Gabriel Robert'
    },
    status: 'planned',
    start: getDate(3, 13), // In 3 days at 13:00
    end: getDate(3, 14, 30), // In 3 days at 14:30
    estimatedDuration: 1.5,
    interventionDetails: 'Révision périodique',
    technician: 'John Doe'
  },
  {
    id: '6',
    title: 'Réparation Moteur',
    type: 'corrective',
    vehicle: {
      immatriculation: 'FF-678-GG',
      modele: 'Transit',
      marque: 'Ford',
      chauffeur: 'Louis Michel'
    },
    status: 'in_progress',
    start: getDate(4, 15), // In 4 days at 15:00
    end: getDate(4, 17), // In 4 days at 17:00
    estimatedDuration: 2,
    interventionDetails: 'Remplacement courroie distribution',
    technician: 'John Doe'
  },
  {
    id: '7',
    title: 'Vidange',
    type: 'preventive',
    vehicle: {
      immatriculation: 'GG-901-HH',
      modele: 'Master',
      marque: 'Renault',
      chauffeur: 'Arthur Simon'
    },
    status: 'planned',
    start: getDate(7, 8), // In a week at 8:00
    end: getDate(7, 9), // In a week at 9:00
    estimatedDuration: 1,
    interventionDetails: 'Vidange huile et filtres',
    technician: 'John Doe'
  },
  {
    id: '8',
    title: 'Réparation Transmission',
    type: 'corrective',
    vehicle: {
      immatriculation: 'HH-234-II',
      modele: 'Ducato',
      marque: 'Fiat',
      chauffeur: 'Paul Laurent'
    },
    status: 'completed',
    start: getDate(7, 10), // In a week at 10:00
    end: getDate(7, 12), // In a week at 12:00
    estimatedDuration: 2,
    interventionDetails: 'Remplacement embrayage',
    technician: 'John Doe'
  }
];

export default _planningEvents; 