import { INITIAL_ADDRESS, MOCK_ADDRESSES } from '.';
import { Civility, IRepresentative, RelationType } from '../types/usager';

export const _representatives: IRepresentative[] = [
  {
    id: '1',
    civilite: Civility.MM,
    firstName: 'Jean',
    lastName: 'Dupont',
    type: RelationType.PERE,
    parentFirstName: 'Marie',
    parentLastName: 'Dupont',
    address: MOCK_ADDRESSES[0],
    adresseEtablissement: MOCK_ADDRESSES[1],
    schedule: {
      pair: {
        Lundi: { all: true, ret: false },
        Mardi: { all: true, ret: false },
        Mercredi: { all: true, ret: false },
        Jeudi: { all: true, ret: false },
        Vendredi: { all: true, ret: false },
        Samedi: { all: false, ret: false },
        Dimanche: { all: false, ret: false },
      },
      impair: {
        Lundi: { all: true, ret: false },
        Mardi: { all: true, ret: false },
        Mercredi: { all: true, ret: false },
        Jeudi: { all: true, ret: false },
        Vendredi: { all: true, ret: false },
        Samedi: { all: false, ret: false },
        Dimanche: { all: false, ret: false },
      },
    },
    mobile: ['0123456789'],
    email: 'jean.dupont@email.com',
    circuit: 'Circuit A',
  },
];

export const INITIAL_REPRESENTATIVE_DATA: IRepresentative = {
  id: '',
  civilite: Civility.MM,
  firstName: '',
  lastName: '',
  type: RelationType.PERE,
  parentFirstName: '',
  parentLastName: '',
  address: INITIAL_ADDRESS,
  adresseEtablissement: INITIAL_ADDRESS,
  schedule: {
    pair: {
      Lundi: { all: false, ret: false },
      Mardi: { all: false, ret: false },
      Mercredi: { all: false, ret: false },
      Jeudi: { all: false, ret: false },
      Vendredi: { all: false, ret: false },
      Samedi: { all: false, ret: false },
      Dimanche: { all: false, ret: false },
    },
    impair: {
      Lundi: { all: false, ret: false },
      Mardi: { all: false, ret: false },
      Mercredi: { all: false, ret: false },
      Jeudi: { all: false, ret: false },
      Vendredi: { all: false, ret: false },
      Samedi: { all: false, ret: false },
      Dimanche: { all: false, ret: false },
    },
  },
  mobile: [],
  email: '',
  circuit: '',
};
