import { TableColumn } from "../types/common"
import { IValidRoadmap } from "../types/driver"
import { _noms, _prenoms } from "."

const randomNumber = (min: number, max: number) => {
    return Math.floor(Math.random() * (max - min + 1) + min)
  }
  
  const formatTime = (hours: number) => {
    const h = Math.floor(hours)
    const m = Math.round((hours - h) * 60)
    return `${h.toString().padStart(2, "0")}:${m.toString().padStart(2, "0")}`
  }
  
  export const _validRoadmapData = [...Array(50)].map((_, index) => {
    const totalDay = randomNumber(6, 12)
    const totalInHundredths = (totalDay * 100).toString()
    const deductionOrVacation = formatTime(randomNumber(0, 2) + randomNumber(0, 99) / 100)
    const hoursPaidInHundredths = ((totalDay - Number.parseFloat(deductionOrVacation)) * 100).toFixed(0)
    const deltaFixedPackageDeduction = formatTime(randomNumber(0, 1) + randomNumber(0, 99) / 100)
    const packageValue = formatTime(randomNumber(6, 8) + randomNumber(0, 99) / 100)
    const nightHours = formatTime(randomNumber(0, 3) + randomNumber(0, 99) / 100)
    const waitingHours = formatTime(randomNumber(0, 2) + randomNumber(0, 99) / 100)
    const numberOfVacations = randomNumber(0, 5).toString()
  
    return {
      id: (index + 1).toString(),
      driverName: `${_prenoms[index % _prenoms.length]} ${_noms[index % _noms.length]}`,
      totalDay: totalDay.toString(),
      totalInHundredths: totalInHundredths,
      deductionOrVacation: deductionOrVacation,
      hoursPaidInHundredths: hoursPaidInHundredths,
      deltaFixedPackageDeduction: deltaFixedPackageDeduction,
      package: packageValue,
      nightHours: nightHours,
      waitingHours: waitingHours,
      numberOfVacations: numberOfVacations,
  } as IValidRoadmap
})

export const DEFAULT_VALID_ROADMAP_TABLE_HEAD: TableColumn[] = [
    { id: "driverName", label: "Nom du chauffeur", type: "text" },
    { id: "totalDay", label: "Total journée", type: "number", align: "center" },
    { id: "totalInHundredths", label: "Total en centième", type: "number", align: "center" },
    { id: "deductionOrVacation", label: "Déduction ou vacation", type: "number", align: "center" },
    { id: "hoursPaidInHundredths", label: "Heures payées en centième", type: "number", align: "center" },
    { id: "deltaFixedPackageDeduction", label: "Delta forfait fixe-deduc", type: "number", align: "center" },
    { id: "package", label: "Forfait", type: "number", align: "center" },
    { id: "nightHours", label: "Heures de nuit", type: "number", align: "center" },
    { id: "waitingHours", label: "Heures d'attente", type: "number", align: "center" },
    { id: "numberOfVacations", label: "Nb de vacation", type: "number", align: "center" },
    { id: 'anciennesListes', label: 'Anciennes listes', type: 'action', align: 'center' },
  ]

export const INITIAL_VALID_ROADMAP: IValidRoadmap = {
    id: "",
    driverName: "",
    totalDay: "",
    totalInHundredths: "",
    deductionOrVacation: "",
    hoursPaidInHundredths: "",
    deltaFixedPackageDeduction: "",
    package: "",
    nightHours: "",
    waitingHours: "",
    numberOfVacations: "",
  }
  
  