import { Box, Chip, Stack, Typography } from '@mui/material';
import { styled } from '@mui/material/styles';
import { JoursAttribues } from '../types/chauffeur';

const DayChip = styled(Chip)(({ theme }) => ({
  width: 20,
  height: 20,
  borderRadius: '50%',
  fontSize: '0.55rem',
  '& .MuiChip-label': {
    padding: 0,
  },
  '&.active': {
    backgroundColor: theme.palette.primary.main,
    color: theme.palette.primary.contrastText,
  },
  '&.inactive': {
    backgroundColor: 'transparent',
    border: `1px solid ${theme.palette.primary.main}`
  }
}));

interface JoursAttribuesGridProps {
  jours: JoursAttribues;
}

const daysMap = {
  lundi: 'L',
  mardi: 'M',
  mercredi: 'M',
  jeudi: 'J',
  vendredi: 'V',
  samedi: 'S',
  dimanche: 'D',
};

export default function JoursAttribuesGrid({ jours }: JoursAttribuesGridProps) {
  const renderDayPeriod = (day: keyof typeof daysMap, period: { matin: boolean; soir: boolean }) => (
    <Stack direction="row" spacing={0.3} alignItems="center">
      <DayChip
        label={`${daysMap[day]}M`}
        className={period.matin ? 'active' : 'inactive'}
        size="small"  
      />
      <DayChip
        label={`${daysMap[day]}S`}
        className={period.soir ? 'active' : 'inactive'}
        size="small"
      />
    </Stack>
  );

  return (
    <Box sx={{ py: 1.5 }}>
    <Stack spacing={1.5}>
      <Box>
        <Stack direction="row" alignItems="center" spacing={1}>
          <Typography sx={{fontSize:'9px',width:30, textAlign: 'left'}} >
            Paire
          </Typography>
          <Stack direction="row" spacing={1} justifyContent="space-between" flexGrow={1}>
            {Object.entries(jours.pair).map(([day, periods]) => (
              <Box key={`pair-${day}`}>
                {renderDayPeriod(day as keyof typeof daysMap, periods)}
              </Box>
            ))}
          </Stack>
        </Stack>
      </Box>
      <Box>
        <Stack direction="row" alignItems="center" spacing={1}>
          <Typography sx={{fontSize:'9px',width:30,}} >
            Impaire
          </Typography>
          <Stack direction="row" spacing={1} justifyContent="space-between" flexGrow={1}>
            {Object.entries(jours.impair).map(([day, periods]) => (
              <Box key={`impair-${day}`}>
                {renderDayPeriod(day as keyof typeof daysMap, periods)}
              </Box>
            ))}
          </Stack>
        </Stack>
      </Box>
    </Stack>
  </Box>
  );
}

