/* eslint-disable @next/next/no-img-element */
import { forwardRef } from 'react';
import Link from '@mui/material/Link';
import Box, { BoxProps } from '@mui/material/Box';
import {RouterLink} from '@/routes/router-link';

// ----------------------------------------------------------------------

export interface SecondaryLogoProps extends BoxProps {
  disabledLink?: boolean;
}

const SecondaryLogo = forwardRef<HTMLDivElement, SecondaryLogoProps>(
  ({ disabledLink = false, sx, ...other }, ref) => {
    const logo = (
      <Box
        ref={ref}
        component="div"
        sx={{
          width: 40,
          height: 40,
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          ...sx,
        }}
        {...other}
      >
        <img src="/logo/secondary_logo.png" alt="Logo" />
      </Box>
    );

    if (disabledLink) {
      return logo;
    }

    return (
      <Link component={RouterLink} href="/" sx={{ display: 'contents' }}>
        {logo}
      </Link>
    );
  }
);
SecondaryLogo.displayName = 'SecondaryLogo';

export default SecondaryLogo;
