import type React from "react"
import { Box, IconButton } from "@mui/material"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import { AddButton, ColumnButton, secoundaryColor, mainColor } from "./styles"
import FontAwesome from "@/shared/components/fontawesome"
import { faAngleDoubleLeft, faFileExport, faFileImport, faSquarePlus } from "@fortawesome/free-solid-svg-icons"
import { WhiteIconButtonStyle } from "@/shared/theme/css"
import { TableType } from "@/shared/types/common"

interface MapsControlBarProps {
  onImport?: () => void
  onExport?: () => void
  onAdd?: () => void
  onViewList?: () => void
  label?: TableType
  addLabel?: string
}

const MapsControlBar: React.FC<MapsControlBarProps> = ({
  onImport,
  onExport,
  onAdd,
  onViewList,
  label = TableType.Circuit,
  addLabel = "Nouvel élément",
}) => {
  return (
    <Box sx={{ display: "flex", alignItems: "center", gap: 1, pt: 1, pb: 1 }}>
      {onExport ? (
        <AddButton variant="contained" onClick={onExport} endIcon={<FontAwesome icon={faFileExport} width={16} />}>
          Générer circuits optimal
        </AddButton>
      ): <></>}

      {onImport ? (
        <CustomTooltip title={`Importer les ${label}s en masse`} arrow>
          <ColumnButton
            variant="contained"
            sx={onExport ? { ...secoundaryColor } : { ...mainColor }}
            onClick={onImport}
            endIcon={<FontAwesome icon={faFileImport} width={16} />}
          >
            Importer en masse
          </ColumnButton>
        </CustomTooltip>
      ): <></>}

      {onAdd ? (
        <CustomTooltip title={addLabel} arrow>
          <IconButton sx={secoundaryColor} onClick={onAdd}>
            <FontAwesome icon={faSquarePlus} width={18} />
          </IconButton>
        </CustomTooltip>
      ) : <></>}

      {onViewList ? (
        <CustomTooltip title={`Consulter liste des ${label}s`} arrow>
          <IconButton sx={WhiteIconButtonStyle} onClick={onViewList}>
            <FontAwesome icon={faAngleDoubleLeft} width={18} />
          </IconButton>
        </CustomTooltip>
      ): <></>}
    </Box>
  )
}

export default MapsControlBar

