'use client';

import React from 'react';
import { Box, Stack } from '@mui/material';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useAgentTable } from '../hooks/use-agent-table';
import CustomTabs from '@/shared/components/tabs/tabs-custom';
import { IAgent } from '@/shared/types/agent';
import AgentTable from '../components/agent-table';
import { TableType } from '@/shared/types/common';
import { useAgentTabs } from '../hooks/use-agent-tabs';
import AgentForm from './agent-new-view';
import { HEADER } from '@/layouts/config-layout';
import { UnsavedChangesDialog } from '@/shared/components/dialog/UnsavedChangesDialog';

export default function AgentContent() {
  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleCopy,
    setTabHasUnsavedChanges,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
  } = useAgentTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    handleStatusChange
  } = useAgentTable();

  const activeTabData = React.useMemo(() => {
    return tabs.find((tab: { id: any; }) => tab.id === activeTab);
  }, [tabs, activeTab]);

  return (
    <Box
    sx={{
      display: 'flex',
      flexDirection: 'column',
      height: '100%',
    }}
  >
    <Stack
      flexGrow={0}
      direction="row"
      alignItems="center"
      justifyContent="flex-end"
      spacing={{ xs: 0.5, sm: 1 }}
    >
      
        <TableControlBar
          type={TableType.Agent}
          activeTab={activeTab}
          handleTabAdd={handleTabAdd}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={filteredData}
        />
      </Stack>

      {/* Onglets */}
      <CustomTabs
        type={TableType.Agent}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />


    
        {activeTab === 'list' ? (
          <AgentTable
            filteredData={filteredData}
            table={table}
            tableHead={tableHead}
            notFound={notFound}
            filters={filters}
            onFilterChange={handleFilterChange}
            handleEdit={handleEdit}
            handleCopy={handleCopy}
            handleView={handleView}
            onStatusChange={handleStatusChange}
          />
        ) : (
          <AgentForm
            key={activeTab}
            agent={activeTabData?.content as IAgent}
            mode={activeTabData?.mode || 'view'}
            onSave={handleSave}
            onClose={(force) => handleCancel(activeTab, force)}
            onEdit={handleEdit}
            updateTabContent={updateTabContent}
            tabId={activeTab}
          />
        )}
        <UnsavedChangesDialog
        open={showConfirmDialog}
        onClose={() => setShowConfirmDialog(false)}
        onConfirm={() => handleConfirmDialogAction()}
        onCancel={() => setShowConfirmDialog(false)}
      />
      
    </Box>
  );
}