import * as Yup from "yup"
import { EmailTemplateCategory } from "@/shared/types/email-template"

export const emailTemplateSchema = Yup.object({
  titre: Yup.string().required("Le titre est obligatoire"),
  description: Yup.string(),
  categorie: Yup.string()
    .oneOf(Object.values(EmailTemplateCategory), "Catégorie invalide")
    .required("La catégorie est obligatoire"),
  contenu: Yup.string().required("Le contenu est obligatoire"),
  dateCreation: Yup.string(),
  isArchive: Yup.boolean(),
})
