import { FormFieldType } from '@/shared/types/common';
import { DepartmentRequest, IDepartment } from '@/shared/types/infrastructure';
import { faBuilding, faMapLocation, faFile } from '@fortawesome/free-solid-svg-icons';

export const mainDepartmentFormFields = (agencyOptions: { label: string, value: string }[]): FormFieldType<DepartmentRequest>[] => [
    {
        name: 'agencyId',
        label: "Agence",
        placeholder: 'Choisissez une agence',
        type: 'select',
        options: agencyOptions,
        icon: faFile,
    },
    {
        name: 'name',
        label: 'Nom du département',
        placeholder: 'Entrez un nom',
        type: 'text',
        required: true,
        icon: faBuilding,
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez un texte',
        type: 'address',
        icon: faMapLocation,
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        type: 'textarea',
        icon: faFile,
    },
];

export const mainDepartmentConsultFormFields = (): FormFieldType<DepartmentRequest>[] => [
    {
        name: 'name',
        label: 'Nom du département',
        placeholder: 'Entrez un nom',
        type: 'text',
        required: true,
        icon: faBuilding,
    },
    {
        name: 'mapAddresse',
        label: 'Adresse',
        placeholder: 'Entrez un texte',
        type: 'address',
        icon: faMapLocation,
    },
    {
        name: 'description',
        label: 'Description',
        placeholder: 'Écrivez un texte ici',
        type: 'textarea',
        icon: faFile,
    },
];