import { _OPTION_DRIVER_ABSENCE } from "@/shared/_mock/_absenceDriver"
import { _BINARY_Qst } from "@/shared/_mock/_trajets"
import type { FormFieldType } from "@/shared/types/common"
import type { IDriverAbsence } from "@/shared/types/driver-absence"
import { _CHAUFFEURS, _TYPES_ABSENCE, _MODES_RECEPTION } from "@/shared/_mock/_absenceDriver"
import { DEPARTEMENT_OPTIONS } from "@/shared/sections/establishment/attendance/utils/form-fields-attendance"
import { faBuilding, faHashtag } from "@fortawesome/free-solid-svg-icons"
import { _noms } from "@/shared/_mock"
import { DRIVERS } from "@/shared/_mock/_appointment"

export const formFieldsDriverAbsence : FormFieldType<IDriverAbsence>[] = [
  {
    name: "chauffeur",
    label: "Chauffeur",
    type: "select",
    required: true,
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })),
  },
  {
    name: "dateDebut",
    label: "Date de début",
    type: "date",
    required: true,
  },
  {
    name: "dateFin",
    label: "Date de fin",
    type: "date",
    required: true,
  },
  {
    name: "typeAbsence",
    label: "Type d'absence",
    placeholder: "Choisissez une valeur",
    type: "select",
    options: _TYPES_ABSENCE.map((type) => ({ value: type, label: type })),
  },
  {
    name: "modeReception",
    label: "Mode de réception",
    placeholder: "Choisissez une valeur",
    type: "select",
    options: _MODES_RECEPTION.map((mode) => ({ value: mode, label: mode })),
  },
  {
    name: "chauffeurAffecte",
    label: "Chauffeur affecté à un trajet",
    type: "checkbox",
    options: _BINARY_Qst,
  },
  {
    name: "department",
    label: "Departement",
    type: "text",
    required:true,
    icon: faBuilding
  },
  {
    name: "nombreHeures",
    label: "Nombre d'heures",
    type: "text",
    icon:faHashtag
  },
  {
    name: "statut",
    label: "Statut",
    type: "select",
    options: _OPTION_DRIVER_ABSENCE,
  },
  {
    name: "justificatif",
    label: "Justificatif",
    placeholder: "Entrez un text",
    type: "text",
  },
  {
    name: "autorisePar",
    label: "Autorisé Par",
    type: "select",
    options: DRIVERS
  },
  {
    name: "validePar",
    label: "Validé Par",
    type: "select",
    options: DRIVERS
  },
]

