import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { useTheme } from '@mui/material/styles';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { IAddRoadmap } from '@/shared/types/driver';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (roadmap: IAddRoadmap) => void;
  handleDetails: (roadmap: IAddRoadmap) => void;
  handleCopy: (roadmap: IAddRoadmap) => void;
  selected: boolean;
  dense: boolean;
  row: IAddRoadmap;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

export default function AddNewRoaMapTableRow({
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
}: Props) {
  const theme = useTheme();
  const isActive = true;
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      default:
        return value;
    }
  };
  return (
    <ContratStyledRow hover  style={{ cursor: 'pointer' }}>
      {columns.map((column: any, index: number) => (
          <TableCell
            key={column.id}
            align={column.align}
            onDoubleClick={() => handleDetails(row)}
            sx={{ whiteSpace: 'nowrap',
              ...(index === 0 && {
                position: 'relative',
              }),
              py: column.id === 'status' ? 0 : dense ? 0 : 2.3,
            }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: 'absolute', top: 0, left: -4, height: '100%',
                }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof IAddRoadmap])}
          </TableCell>
        ))}
    </ContratStyledRow>
  );
}
