import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { useTheme } from '@mui/material/styles';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { IOldRoadmap } from '@/shared/types/driver';
import { Box } from '@mui/system';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { IconButton } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { ActionsIconButton } from '@/shared/theme/css';
import { faDownload, faEye, faMapMarkedAlt } from '@fortawesome/free-solid-svg-icons';
import { AntSwitch } from '@/shared/components/table/styles';
import { Download } from '@mui/icons-material';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (roadmap: IOldRoadmap) => void;
  handleDetails: (roadmap: IOldRoadmap) => void;
  handleCopy: (roadmap: IOldRoadmap) => void;
  selected: boolean;
  dense: boolean;
  row: IOldRoadmap;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  
};

export default function OldRoaMapsTableRow({
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  dense,
  onSelectRow,
  columns,
}: Props) {
  const theme = useTheme();
  const isActive = true;

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      default:
        return value;
    }
  };

  
  return (
    <ContratStyledRow hover  style={{ cursor: 'pointer' }}>
      {columns
        .slice(0, -1)
        .map((column: any, index: number) => (
          <TableCell      
            onDoubleClick={() => handleDetails(row)}
            key={column.id}
            align={column.align}
            sx={{
              whiteSpace: 'nowrap',
              ...(index === 0 && {
                position: 'relative',
              }),
            }}
          >
            <ConditionalComponent isValid={index === 0}>
              <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.name),
                }}
              />
            </ConditionalComponent>
            {renderCellContent(column.id, row[column.id as keyof IOldRoadmap])}
          </TableCell>
        ))}

        <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <Box sx={{ display: 'flex', justifyContent: 'left', alignItems: 'center', gap: '8px' }}>
        
          <CustomTooltip title="Télécharger" arrow>
            <IconButton size="small" sx={ActionsIconButton}>
              <FontAwesome icon={faDownload} width={16} />
            </IconButton>
          </CustomTooltip>
        </Box>
      </TableCell>
    </ContratStyledRow>
  );
}
