'use client';

import {
  Accordion,
  AccordionSummary,
  AccordionDetails,
  Box,
  Grid,
  Typography,
  Paper
} from '@mui/material';
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';

const periods = ['Matin', 'Midi', 'Après-midi', 'Soir'];

export default function DailyRoadMapAccordionCard({ date }: { date: string }) {
  return (
    <Accordion
      disableGutters
      sx={{
        mt: 1.5,
        backgroundColor: 'transparent',
        borderRadius: '16px',
        boxShadow: 'none',
        '&::before': { display: 'none' },
        '&.Mui-expanded': {
          margin: 0
        }
      }}
    >
      <AccordionSummary
        expandIcon={<ExpandMoreIcon sx={{ color: '#9fa6b2' }} />}
        sx={{
          backgroundColor: '#f5f3ff',
          borderRadius: '16px',
          px: 3,
          py: 2,
          '& .MuiAccordionSummary-content': {
            m: 0
          },
          '& .MuiAccordionSummary-content.Mui-expanded': {
            margin: 0
          }
        }}
      >
        <Typography fontWeight="bold" fontSize="16px" color="text.primary">
          {date}
        </Typography>
      </AccordionSummary>

      <AccordionDetails>
        <Box
          component={Paper}
          sx={{
            mt: 2,
            backgroundColor: '#ffffff',
            borderRadius: '16px',
            px: 3,
            py: 4
          }}
        >
          <Grid container spacing={2}>
            {periods.map((label, index) => (
              <Grid item xs={12} sm={6} md={3} key={index}>
                <Box
                  sx={{
                    bgcolor: '#f5f3ff',
                    p: 2,
                    borderRadius: '12px',
                    textAlign: 'center'
                  }}
                >
                  <Typography fontWeight="600" mb={1}>
                    {label}
                  </Typography>
                  <Grid container spacing={1} justifyContent="center">
                    <Grid item xs={6}>
                      <Typography variant="caption" color="text.secondary">
                        Départ
                      </Typography>
                      <Typography fontWeight="medium" fontSize="15px">
                        08:00
                      </Typography>
                    </Grid>
                    <Grid item xs={6}>
                      <Typography variant="caption" color="text.secondary">
                        Fin
                      </Typography>
                      <Typography fontWeight="medium" fontSize="15px">
                        08:30
                      </Typography>
                    </Grid>
                  </Grid>
                </Box>
              </Grid>
            ))}
          </Grid>

          <Grid container spacing={2} mt={2}>
            <Grid item xs={12} sm={6} md={4}>
              <Box
                sx={{
                  bgcolor: '#f5f3ff',
                  p: 2,
                  borderRadius: '12px',
                  textAlign: 'center'
                }}
              >
                <Typography
                  variant="body2"
                  color="text.secondary"
                  mb={0.5}
                >
                  Nombre de kilomètres en début de journée
                </Typography>
                <Typography fontWeight="bold" color="primary" fontSize="16px">
                  345283
                </Typography>
              </Box>
            </Grid>
            <Grid item xs={12} sm={6} md={4}>
              <Box
                sx={{
                  bgcolor: '#f5f3ff',
                  p: 2,
                  borderRadius: '12px',
                  textAlign: 'center'
                }}
              >
                <Typography
                  variant="body2"
                  color="text.secondary"
                  mb={0.5}
                >
                  Nombre de kilomètres en fin de journée
                </Typography>
                <Typography fontWeight="bold" color="primary" fontSize="16px">
                  345283
                </Typography>
              </Box>
            </Grid>
            <Grid item xs={12} sm={6} md={4}>
              <Box
                sx={{
                  bgcolor: '#f5f3ff',
                  p: 2,
                  borderRadius: '12px',
                  textAlign: 'center'
                }}
              >
                <Typography
                  variant="body2"
                  color="text.secondary"
                  mb={0.5}
                >
                  Montant carburant
                </Typography>
                <Typography fontWeight="bold" color="primary" fontSize="16px">
                  345283
                </Typography>
              </Box>
            </Grid>
            <Grid item xs={12} >
            <Box
                sx={{
                  bgcolor: "#f5f3ff",
                  p: 2,
                  borderRadius: "12px",
                  
                }}
              >
                <Typography variant="body2" color="text.secondary" mb={1} fontWeight="600">
                  Observation
                </Typography>
                <Typography variant="body1" color="text.primary">
                  Observation sur cette Feuille de route.
                </Typography>
              </Box>
            </Grid>
          </Grid>
        </Box>
      </AccordionDetails>
    </Accordion>
  );
}
