'use client';

import { Box } from '@mui/material';
import { ScrollBox } from '@/shared/theme/css';
import CreateRoadMapMileage from './create-roadmap-mileage';
import VisitSection from './add-other-roads';
import UserInformationCard from './create-roadmap-details';
import RoadMapDrawer from './roadmap-drawer';
import { useBoolean } from '@/hooks';
import RoadMapTimePickerComponent from './time-section-roadmap';

export default function CreatRoadMapPage() {
  const DRAWER_WIDTH = 550;
  const openDrawer = useBoolean();

  const handleOnClick = () => {
    openDrawer.onTrue();
  };

  return (
    <Box sx={{ display: 'flex' }}>
      <ScrollBox
        sx={{
          display: 'flex',
          flexDirection: 'column',
          width: openDrawer.value ? `calc(100% - ${DRAWER_WIDTH}px)` : '100%',
        }}
      >
        <UserInformationCard handleOnClick={handleOnClick} />

        <RoadMapTimePickerComponent />
        <CreateRoadMapMileage />
        <VisitSection />
      </ScrollBox>

      <RoadMapDrawer isOpen={openDrawer} onClose={openDrawer.onFalse} />
    </Box>
  );
}
