'use client';

import CustomDrawer from '@/shared/components/drawer/custom-drawer';
import RoadMapHistoryTable from '../../roadmap-list/add-roadmap/roadmap-history-table';

const DRAWER_WIDTH = 550;

type Props = {
  isOpen: any;
  onClose: () => void;
};

export default function RoadMapDrawer({ isOpen, onClose }: Props) {
  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen.value} onClose={onClose}>
      <RoadMapHistoryTable condensed={true} />
    </CustomDrawer>
  );
}
