'use client'

import React from 'react'
import {
  Dialog,
  DialogTitle,
  DialogContent,
  IconButton,
  List,
  ListItem,
  ListItemText,
} from '@mui/material'
import CloseIcon from '@mui/icons-material/Close'

export interface TrajetDetailsDialogProps {
    open: boolean
    onClose: () => void
    data?: {
      totalJournee?: string
      totalCentiemes?: string
      deduction?: string
      heuresPayees?: string
      delta?: string
      forfait?: string
      heuresNuit?: string
      heuresAttente?: string
      nbVacation?: number
    }
  }
  

export default function TrajetDetailsDialog({ open, onClose, data }: TrajetDetailsDialogProps) {
  return (
    <Dialog open={open} onClose={onClose} maxWidth="xs" fullWidth>
      <DialogTitle>
        Détails du Trajet
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{ position: 'absolute', right: 8, top: 8 }}
        >
          <CloseIcon />
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        {data ? (
          <List dense>
            <ListItem><ListItemText primary="Total journée" secondary={data.totalJournee || '--'} /></ListItem>
            <ListItem><ListItemText primary="Total en centièmes" secondary={data.totalCentiemes || '--'} /></ListItem>
            <ListItem><ListItemText primary="Déduction ou vacation" secondary={data.deduction || '--'} /></ListItem>
            <ListItem><ListItemText primary="H PAYÉES en centièmes" secondary={data.heuresPayees || '--'} /></ListItem>
            <ListItem><ListItemText primary="Delta forfait-réel-déduc" secondary={data.delta || '--'} /></ListItem>
            <ListItem><ListItemText primary="Forfait" secondary={data.forfait || '--'} /></ListItem>
            <ListItem><ListItemText primary="Heures de nuit" secondary={data.heuresNuit || '--'} /></ListItem>
            <ListItem><ListItemText primary="Heures d'attente" secondary={data.heuresAttente || '--'} /></ListItem>
            <ListItem><ListItemText primary="Nb de vacation" secondary={data.nbVacation?.toString() || '--'} /></ListItem>
          </List>
        ) : null}
      </DialogContent>
    </Dialog>
  )
}
