import React from 'react';
import { ICircuit } from '@/shared/types/circuit';
import TableManager from '@/shared/components/table/table-manager';
import CircuitTableRow from '../view/circuit-table-row';
import { TableColumn } from '@/shared/types/common';


interface CircuitTableProps {
  filteredData: ICircuit[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: ICircuit) => void;
  handleView: (item: ICircuit) => void;
  onStatusChange: (row: ICircuit, newStatus: string, field: keyof ICircuit) => void;
}

export default function CircuitTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  onStatusChange
}: CircuitTableProps) {
  const renderRow = (row: ICircuit) => (
     <CircuitTableRow
          dense={table.dense}
          key={row.id}
          row={row}
          handleEditContract={handleEdit}
          handleDetailsContract={handleView}
          selected={table.selected.includes(row.id)}
          onSelectRow={() => table.onSelectRow(row.id)}
          columns={tableHead.slice(0, -1)}
          onStatusChange={onStatusChange}
        />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
    />
  );
}

