import React from 'react';
import { _CIRCUIT_STATUS, _TRAJET_DUREES } from "@/shared/_mock/_circuit";
import FontAwesome from "@/shared/components/fontawesome";
import { IChauffeur, Interval } from "@/shared/types/chauffeur";
import { ICircuit, ICircuitContract } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";
import { IDocument } from "@/shared/types/document";
import { faAddressCard, faArrowRight, faEuro, faEye, faHashtag, faStickyNote} from "@fortawesome/free-solid-svg-icons";
import { _BINARY_Qst } from '@/shared/_mock/_trajets';

const TRAJET_OPTIONS: Interval[] = [
  { depart: 'Paris', arriver: 'Lyon' },
  { depart: 'Marseille', arriver: 'Nice' },
  { depart: 'Bordeaux', arriver: 'Toulouse' },
];

export const formFieldsCircuit: FormFieldType<ICircuit>[] = [
  {
    name: 'etat',
    label: 'État du circuit',
    type: 'select',
    options: _CIRCUIT_STATUS,
  },
  {
    name: 'etablissement',
    label: 'Établissement principal',
    type: 'text',
    placeholder: 'Entrez un nom',
    required: true,
    icon: '/assets/icons/form/ic_building.svg',
  },
  {
    name: 'adresseEtablissement',
    label: 'Prise en charge',
    type: 'address',
    placeholder: 'Entrez une adresse',
  },
  {
    name: 'typeCalcul',
    label: 'Type de calcul',
    type: 'select',
    options: [
      { value: 'calculCouts', label: 'Calcul pour les Coûts' },
      { value: 'calculAutres', label: 'Autres calculs' },
    ],
  },
  {
    name: 'grillePrix',
    label: 'Grille de prix',
    type: 'text',
    placeholder: '0',
    icon: faEuro,
  },
  {
    name: 'dateDebut',
    label: 'Date de début',
    type: 'date',
    required: true,
  },
  {
    name: 'dateFin',
    label: 'Date de fin',
    type: 'date',
    required: true,
  },
  {
    name: 'colorCode',
    label: 'Code couleur',
    type: 'color',
    placeholder: 'Choisissez une couleur',
    required: true,
  },
  {
    name: 'chauffeur',
    label: 'Chauffeurs',
    type: 'text',
    placeholder: 'Entrez un nom',
    icon: faAddressCard,
  },
  {
    name: 'dureeTrajet',
    label: 'Paramètres trajet',
    type: 'select',
    placeholder: 'Sélectionnez une durée',
    options: _TRAJET_DUREES,
  },
  {
    name: 'observation',
    label: "Observation",
    placeholder:"Ajoutez une note ou une observation",
    type: 'textarea',
    icon: faStickyNote,
  },
];
export const numeroLotOptions = [
  { value: 'BCI256579345', label: 'BCI256579345' },
  { value: 'BCI256579347', label: 'BCI256579347' },
  { value: 'BCI25657934', label: 'BCI25657934' },
  { value: 'BCI256579349', label: 'BCI256579349' },
  { value: 'BCI256579346', label: 'BCI256579346' },
  { value: 'BCI256579348', label: 'BCI256579348' }
];
export const formFieldsCircuitContrat: FormFieldType<ICircuitContract>[] = [
  {
    name: 'contrat',
    label: 'Contrat',
    type: 'text',
    placeholder: 'Entrez un nom',
    icon: faEye,
  },
  {
    name: 'numeroLot',
    label: 'N° de lot',
    type: 'multiple',
    options:numeroLotOptions
  },
];

export const formFieldsChauffeur: FormFieldType<IChauffeur>[] = [
  {
    name: 'trajet',
    label: 'Trajet',
    type: 'select',
    placeholder: 'Sélectionnez un trajet',
    options: TRAJET_OPTIONS.map((trajet) => ({
      value: `${trajet.depart}-${trajet.arriver}`,
      label: (
        <>
          {trajet.depart}
          <FontAwesome icon={faArrowRight} width={12} style={{ padding: '0 4px' }} />
          {trajet.arriver}
        </>
      ),
    })),
  },
  {
    name: 'chauffeur',
    label: 'Chauffeur',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faAddressCard,
  },
  {
    name: 'dateDebut',
    label: 'A parir du',
    required: true,
    type: 'date',
  },
  {
    name: 'dateFin',
    label: "Jusqu'au",
    type: 'date',
  },
  {
    name: 'joursAttribues',
    label: "Jours Attribues",
    type: 'select',
  },
  {
    name: 'observation',
    label: "Observation",
    placeholder:"Ajoutez une note ou une observation",
    type: 'text',
    icon: faStickyNote,
  },
];

export const formConfig : FormFieldType<ICircuit>[] = [
    {
      name: 'codeCircuit',
      label: 'Code Circuit',
      type: 'text',
      placeholder: '00',
      icon: faHashtag,
      required: true
    },
    {
      name: 'intitule',
      label: 'Intitulé',
      type: 'text',
      placeholder: 'Entrez un nom',
      required: true
    },
  ]

export const getEtatColor = (status: string) => {
  switch (status) {
    case 'controle':
      return '#81919A';
    case 'non_controle':
      return '#eab308';
    default:
      return '#F9B90B';
  }
};
