import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { IFileImport } from '@/shared/types/vacance';
import { DrawerStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { dateFormat, formatDate } from '@/utils/format-time';
import ConditionalComponent from '../../../../components/table/ConditionalComponent';

type Props = {
  handleEdit: (vacance: IFileImport) => void;
  handleDetails: (vacance: IFileImport) => void;
  handleCopy: (vacance: IFileImport) => void;
  selected: boolean;
  row: IFileImport;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

const TOOLTIP_TITLES = {
  edit: 'Modifier période de vacances',
  duplicate: 'Copier période de vacances',
  active: 'période de vacances actif',
  inactive: 'période de vacances inactif',
};

export default function VacanceTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "importDate":
        return formatDate(value,dateFormat.isoDate);
      default:
        return value;
    }
  };

  return (
    <DrawerStyledRow selected={selected} style={{ cursor: 'pointer' }}>
 
      {columns.filter((column) => column.id !== 'isActive')
        .map((column: any,index) => (
        <TableCell
          onDoubleClick={() => handleDetails(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap', py: dense ? 0 : 2,...(index===0 && {position:"relative"}) }}
        >
          <ConditionalComponent isValid={index ===0}>
          <SvgColor
          src="/assets/icons/ic_border.svg"
          sx={{
            position: 'absolute',
            top: 0,
            left: -4,
            height: '100%',
            color: getStatusColor(row.fileName),
          }}
        />
          </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IFileImport])}
          </TableCell>
      ))}
      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <TableActionColumn
          handleEdit={() => handleEdit(row)}
          onDuplicate={() => handleCopy(row)}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </DrawerStyledRow>
  );
}