import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import { _vehicleAffectations, DEFAULT_AFFECTAITON_TABLE_HEAD } from "@/shared/_mock/flottes/_affectation"
import { IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation"

const affectationConfig: TableConfig<IVehicleAffectation> = {
  initialData: _vehicleAffectations,
  defaultTableHead: DEFAULT_AFFECTAITON_TABLE_HEAD,
}

export function useAffectationTable() {
  return useTableManager<IVehicleAffectation>(affectationConfig)
}

